/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DelegationProperties;
import com.azure.resourcemanager.network.models.InternetIngressPublicIpsProperties;
import com.azure.resourcemanager.network.models.NetworkVirtualAppliancePropertiesFormatNetworkProfile;
import com.azure.resourcemanager.network.models.PartnerManagedResourceProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualApplianceAdditionalNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceSkuProperties;
import java.io.IOException;
import java.util.List;

public final class NetworkVirtualAppliancePropertiesFormat
implements JsonSerializable<NetworkVirtualAppliancePropertiesFormat> {
    private VirtualApplianceSkuProperties nvaSku;
    private String addressPrefix;
    private List<String> bootStrapConfigurationBlobs;
    private SubResource virtualHub;
    private List<String> cloudInitConfigurationBlobs;
    private String cloudInitConfiguration;
    private Long virtualApplianceAsn;
    private String sshPublicKey;
    private List<VirtualApplianceNicProperties> virtualApplianceNics;
    private NetworkVirtualAppliancePropertiesFormatNetworkProfile networkProfile;
    private List<VirtualApplianceAdditionalNicProperties> additionalNics;
    private List<InternetIngressPublicIpsProperties> internetIngressPublicIps;
    private List<SubResource> virtualApplianceSites;
    private List<SubResource> virtualApplianceConnections;
    private List<SubResource> inboundSecurityRules;
    private ProvisioningState provisioningState;
    private String deploymentType;
    private DelegationProperties delegation;
    private PartnerManagedResourceProperties partnerManagedResource;

    public VirtualApplianceSkuProperties nvaSku() {
        return this.nvaSku;
    }

    public NetworkVirtualAppliancePropertiesFormat withNvaSku(VirtualApplianceSkuProperties nvaSku) {
        this.nvaSku = nvaSku;
        return this;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public List<String> bootStrapConfigurationBlobs() {
        return this.bootStrapConfigurationBlobs;
    }

    public NetworkVirtualAppliancePropertiesFormat withBootStrapConfigurationBlobs(List<String> bootStrapConfigurationBlobs) {
        this.bootStrapConfigurationBlobs = bootStrapConfigurationBlobs;
        return this;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public NetworkVirtualAppliancePropertiesFormat withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<String> cloudInitConfigurationBlobs() {
        return this.cloudInitConfigurationBlobs;
    }

    public NetworkVirtualAppliancePropertiesFormat withCloudInitConfigurationBlobs(List<String> cloudInitConfigurationBlobs) {
        this.cloudInitConfigurationBlobs = cloudInitConfigurationBlobs;
        return this;
    }

    public String cloudInitConfiguration() {
        return this.cloudInitConfiguration;
    }

    public NetworkVirtualAppliancePropertiesFormat withCloudInitConfiguration(String cloudInitConfiguration) {
        this.cloudInitConfiguration = cloudInitConfiguration;
        return this;
    }

    public Long virtualApplianceAsn() {
        return this.virtualApplianceAsn;
    }

    public NetworkVirtualAppliancePropertiesFormat withVirtualApplianceAsn(Long virtualApplianceAsn) {
        this.virtualApplianceAsn = virtualApplianceAsn;
        return this;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public NetworkVirtualAppliancePropertiesFormat withSshPublicKey(String sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public List<VirtualApplianceNicProperties> virtualApplianceNics() {
        return this.virtualApplianceNics;
    }

    public NetworkVirtualAppliancePropertiesFormatNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public NetworkVirtualAppliancePropertiesFormat withNetworkProfile(NetworkVirtualAppliancePropertiesFormatNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public List<VirtualApplianceAdditionalNicProperties> additionalNics() {
        return this.additionalNics;
    }

    public NetworkVirtualAppliancePropertiesFormat withAdditionalNics(List<VirtualApplianceAdditionalNicProperties> additionalNics) {
        this.additionalNics = additionalNics;
        return this;
    }

    public List<InternetIngressPublicIpsProperties> internetIngressPublicIps() {
        return this.internetIngressPublicIps;
    }

    public NetworkVirtualAppliancePropertiesFormat withInternetIngressPublicIps(List<InternetIngressPublicIpsProperties> internetIngressPublicIps) {
        this.internetIngressPublicIps = internetIngressPublicIps;
        return this;
    }

    public List<SubResource> virtualApplianceSites() {
        return this.virtualApplianceSites;
    }

    public List<SubResource> virtualApplianceConnections() {
        return this.virtualApplianceConnections;
    }

    public List<SubResource> inboundSecurityRules() {
        return this.inboundSecurityRules;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String deploymentType() {
        return this.deploymentType;
    }

    public DelegationProperties delegation() {
        return this.delegation;
    }

    public NetworkVirtualAppliancePropertiesFormat withDelegation(DelegationProperties delegation) {
        this.delegation = delegation;
        return this;
    }

    public PartnerManagedResourceProperties partnerManagedResource() {
        return this.partnerManagedResource;
    }

    public NetworkVirtualAppliancePropertiesFormat withPartnerManagedResource(PartnerManagedResourceProperties partnerManagedResource) {
        this.partnerManagedResource = partnerManagedResource;
        return this;
    }

    public void validate() {
        if (this.nvaSku() != null) {
            this.nvaSku().validate();
        }
        if (this.virtualApplianceNics() != null) {
            this.virtualApplianceNics().forEach(e -> e.validate());
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.additionalNics() != null) {
            this.additionalNics().forEach(e -> e.validate());
        }
        if (this.internetIngressPublicIps() != null) {
            this.internetIngressPublicIps().forEach(e -> e.validate());
        }
        if (this.delegation() != null) {
            this.delegation().validate();
        }
        if (this.partnerManagedResource() != null) {
            this.partnerManagedResource().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("nvaSku", (JsonSerializable)this.nvaSku);
        jsonWriter.writeArrayField("bootStrapConfigurationBlobs", this.bootStrapConfigurationBlobs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("virtualHub", (JsonSerializable)this.virtualHub);
        jsonWriter.writeArrayField("cloudInitConfigurationBlobs", this.cloudInitConfigurationBlobs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cloudInitConfiguration", this.cloudInitConfiguration);
        jsonWriter.writeNumberField("virtualApplianceAsn", (Number)this.virtualApplianceAsn);
        jsonWriter.writeStringField("sshPublicKey", this.sshPublicKey);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeArrayField("additionalNics", this.additionalNics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("internetIngressPublicIps", this.internetIngressPublicIps, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("delegation", (JsonSerializable)this.delegation);
        jsonWriter.writeJsonField("partnerManagedResource", (JsonSerializable)this.partnerManagedResource);
        return jsonWriter.writeEndObject();
    }

    public static NetworkVirtualAppliancePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkVirtualAppliancePropertiesFormat)jsonReader.readObject(reader -> {
            NetworkVirtualAppliancePropertiesFormat deserializedNetworkVirtualAppliancePropertiesFormat = new NetworkVirtualAppliancePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nvaSku".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.nvaSku = VirtualApplianceSkuProperties.fromJson(reader);
                    continue;
                }
                if ("addressPrefix".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.addressPrefix = reader.getString();
                    continue;
                }
                if ("bootStrapConfigurationBlobs".equals(fieldName)) {
                    List bootStrapConfigurationBlobs;
                    deserializedNetworkVirtualAppliancePropertiesFormat.bootStrapConfigurationBlobs = bootStrapConfigurationBlobs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("virtualHub".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.virtualHub = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("cloudInitConfigurationBlobs".equals(fieldName)) {
                    List cloudInitConfigurationBlobs;
                    deserializedNetworkVirtualAppliancePropertiesFormat.cloudInitConfigurationBlobs = cloudInitConfigurationBlobs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cloudInitConfiguration".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.cloudInitConfiguration = reader.getString();
                    continue;
                }
                if ("virtualApplianceAsn".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.virtualApplianceAsn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sshPublicKey".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.sshPublicKey = reader.getString();
                    continue;
                }
                if ("virtualApplianceNics".equals(fieldName)) {
                    List virtualApplianceNics;
                    deserializedNetworkVirtualAppliancePropertiesFormat.virtualApplianceNics = virtualApplianceNics = reader.readArray(reader1 -> VirtualApplianceNicProperties.fromJson(reader1));
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.networkProfile = NetworkVirtualAppliancePropertiesFormatNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("additionalNics".equals(fieldName)) {
                    List additionalNics;
                    deserializedNetworkVirtualAppliancePropertiesFormat.additionalNics = additionalNics = reader.readArray(reader1 -> VirtualApplianceAdditionalNicProperties.fromJson(reader1));
                    continue;
                }
                if ("internetIngressPublicIps".equals(fieldName)) {
                    List internetIngressPublicIps;
                    deserializedNetworkVirtualAppliancePropertiesFormat.internetIngressPublicIps = internetIngressPublicIps = reader.readArray(reader1 -> InternetIngressPublicIpsProperties.fromJson(reader1));
                    continue;
                }
                if ("virtualApplianceSites".equals(fieldName)) {
                    List virtualApplianceSites;
                    deserializedNetworkVirtualAppliancePropertiesFormat.virtualApplianceSites = virtualApplianceSites = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("virtualApplianceConnections".equals(fieldName)) {
                    List virtualApplianceConnections;
                    deserializedNetworkVirtualAppliancePropertiesFormat.virtualApplianceConnections = virtualApplianceConnections = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("inboundSecurityRules".equals(fieldName)) {
                    List inboundSecurityRules;
                    deserializedNetworkVirtualAppliancePropertiesFormat.inboundSecurityRules = inboundSecurityRules = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.deploymentType = reader.getString();
                    continue;
                }
                if ("delegation".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.delegation = DelegationProperties.fromJson(reader);
                    continue;
                }
                if ("partnerManagedResource".equals(fieldName)) {
                    deserializedNetworkVirtualAppliancePropertiesFormat.partnerManagedResource = PartnerManagedResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkVirtualAppliancePropertiesFormat;
        });
    }
}

