/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkVirtualApplianceSkuInstances;
import java.io.IOException;
import java.util.List;

public final class NetworkVirtualApplianceSkuPropertiesFormat
implements JsonSerializable<NetworkVirtualApplianceSkuPropertiesFormat> {
    private String vendor;
    private List<String> availableVersions;
    private List<NetworkVirtualApplianceSkuInstances> availableScaleUnits;

    public String vendor() {
        return this.vendor;
    }

    public List<String> availableVersions() {
        return this.availableVersions;
    }

    public List<NetworkVirtualApplianceSkuInstances> availableScaleUnits() {
        return this.availableScaleUnits;
    }

    public NetworkVirtualApplianceSkuPropertiesFormat withAvailableScaleUnits(List<NetworkVirtualApplianceSkuInstances> availableScaleUnits) {
        this.availableScaleUnits = availableScaleUnits;
        return this;
    }

    public void validate() {
        if (this.availableScaleUnits() != null) {
            this.availableScaleUnits().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("availableScaleUnits", this.availableScaleUnits, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkVirtualApplianceSkuPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkVirtualApplianceSkuPropertiesFormat)jsonReader.readObject(reader -> {
            NetworkVirtualApplianceSkuPropertiesFormat deserializedNetworkVirtualApplianceSkuPropertiesFormat = new NetworkVirtualApplianceSkuPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vendor".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceSkuPropertiesFormat.vendor = reader.getString();
                    continue;
                }
                if ("availableVersions".equals(fieldName)) {
                    List availableVersions;
                    deserializedNetworkVirtualApplianceSkuPropertiesFormat.availableVersions = availableVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("availableScaleUnits".equals(fieldName)) {
                    List availableScaleUnits;
                    deserializedNetworkVirtualApplianceSkuPropertiesFormat.availableScaleUnits = availableScaleUnits = reader.readArray(reader1 -> NetworkVirtualApplianceSkuInstances.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkVirtualApplianceSkuPropertiesFormat;
        });
    }
}

