/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteMapRule;
import java.io.IOException;
import java.util.List;

public final class RouteMapProperties
implements JsonSerializable<RouteMapProperties> {
    private List<String> associatedInboundConnections;
    private List<String> associatedOutboundConnections;
    private List<RouteMapRule> rules;
    private ProvisioningState provisioningState;

    public List<String> associatedInboundConnections() {
        return this.associatedInboundConnections;
    }

    public RouteMapProperties withAssociatedInboundConnections(List<String> associatedInboundConnections) {
        this.associatedInboundConnections = associatedInboundConnections;
        return this;
    }

    public List<String> associatedOutboundConnections() {
        return this.associatedOutboundConnections;
    }

    public RouteMapProperties withAssociatedOutboundConnections(List<String> associatedOutboundConnections) {
        this.associatedOutboundConnections = associatedOutboundConnections;
        return this;
    }

    public List<RouteMapRule> rules() {
        return this.rules;
    }

    public RouteMapProperties withRules(List<RouteMapRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("associatedInboundConnections", this.associatedInboundConnections, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("associatedOutboundConnections", this.associatedOutboundConnections, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RouteMapProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RouteMapProperties)jsonReader.readObject(reader -> {
            RouteMapProperties deserializedRouteMapProperties = new RouteMapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("associatedInboundConnections".equals(fieldName)) {
                    List associatedInboundConnections;
                    deserializedRouteMapProperties.associatedInboundConnections = associatedInboundConnections = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("associatedOutboundConnections".equals(fieldName)) {
                    List associatedOutboundConnections;
                    deserializedRouteMapProperties.associatedOutboundConnections = associatedOutboundConnections = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedRouteMapProperties.rules = rules = reader.readArray(reader1 -> RouteMapRule.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRouteMapProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteMapProperties;
        });
    }
}

