/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RoutingIntentProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingPolicy;
import java.io.IOException;
import java.util.List;

public final class RoutingIntentInner
extends SubResource {
    private RoutingIntentProperties innerProperties;
    private String name;
    private String etag;
    private String type;

    private RoutingIntentProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public RoutingIntentInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public RoutingIntentInner withId(String id) {
        super.withId(id);
        return this;
    }

    public List<RoutingPolicy> routingPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().routingPolicies();
    }

    public RoutingIntentInner withRoutingPolicies(List<RoutingPolicy> routingPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingIntentProperties();
        }
        this.innerProperties().withRoutingPolicies(routingPolicies);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static RoutingIntentInner fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingIntentInner)((Object)jsonReader.readObject(reader -> {
            RoutingIntentInner deserializedRoutingIntentInner = new RoutingIntentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoutingIntentInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRoutingIntentInner.innerProperties = RoutingIntentProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoutingIntentInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRoutingIntentInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoutingIntentInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingIntentInner;
        }));
    }
}

