/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayConnectionPropertiesFormatInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.models.GatewayCustomBgpIpAddressIpConfiguration;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionMode;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualNetworkGatewayConnectionInner
extends Resource {
    private VirtualNetworkGatewayConnectionPropertiesFormatInner innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
    private String etag;
    private String id;
    private String type;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayConnectionInner.class);

    private VirtualNetworkGatewayConnectionPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkGatewayConnectionInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public VirtualNetworkGatewayConnectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkGatewayConnectionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    public VirtualNetworkGatewayConnectionInner withAuthorizationKey(String authorizationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withAuthorizationKey(authorizationKey);
        return this;
    }

    public VirtualNetworkGatewayInner virtualNetworkGateway1() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkGateway1();
    }

    public VirtualNetworkGatewayConnectionInner withVirtualNetworkGateway1(VirtualNetworkGatewayInner virtualNetworkGateway1) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withVirtualNetworkGateway1(virtualNetworkGateway1);
        return this;
    }

    public VirtualNetworkGatewayInner virtualNetworkGateway2() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkGateway2();
    }

    public VirtualNetworkGatewayConnectionInner withVirtualNetworkGateway2(VirtualNetworkGatewayInner virtualNetworkGateway2) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withVirtualNetworkGateway2(virtualNetworkGateway2);
        return this;
    }

    public LocalNetworkGatewayInner localNetworkGateway2() {
        return this.innerProperties() == null ? null : this.innerProperties().localNetworkGateway2();
    }

    public VirtualNetworkGatewayConnectionInner withLocalNetworkGateway2(LocalNetworkGatewayInner localNetworkGateway2) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withLocalNetworkGateway2(localNetworkGateway2);
        return this;
    }

    public List<SubResource> ingressNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().ingressNatRules();
    }

    public VirtualNetworkGatewayConnectionInner withIngressNatRules(List<SubResource> ingressNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withIngressNatRules(ingressNatRules);
        return this;
    }

    public List<SubResource> egressNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().egressNatRules();
    }

    public VirtualNetworkGatewayConnectionInner withEgressNatRules(List<SubResource> egressNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withEgressNatRules(egressNatRules);
        return this;
    }

    public VirtualNetworkGatewayConnectionType connectionType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionType();
    }

    public VirtualNetworkGatewayConnectionInner withConnectionType(VirtualNetworkGatewayConnectionType connectionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withConnectionType(connectionType);
        return this;
    }

    public VirtualNetworkGatewayConnectionProtocol connectionProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionProtocol();
    }

    public VirtualNetworkGatewayConnectionInner withConnectionProtocol(VirtualNetworkGatewayConnectionProtocol connectionProtocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withConnectionProtocol(connectionProtocol);
        return this;
    }

    public Integer routingWeight() {
        return this.innerProperties() == null ? null : this.innerProperties().routingWeight();
    }

    public VirtualNetworkGatewayConnectionInner withRoutingWeight(Integer routingWeight) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withRoutingWeight(routingWeight);
        return this;
    }

    public Integer dpdTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().dpdTimeoutSeconds();
    }

    public VirtualNetworkGatewayConnectionInner withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withDpdTimeoutSeconds(dpdTimeoutSeconds);
        return this;
    }

    public VirtualNetworkGatewayConnectionMode connectionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionMode();
    }

    public VirtualNetworkGatewayConnectionInner withConnectionMode(VirtualNetworkGatewayConnectionMode connectionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withConnectionMode(connectionMode);
        return this;
    }

    public String sharedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedKey();
    }

    public VirtualNetworkGatewayConnectionInner withSharedKey(String sharedKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withSharedKey(sharedKey);
        return this;
    }

    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionStatus();
    }

    public List<TunnelConnectionHealth> tunnelConnectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().tunnelConnectionStatus();
    }

    public Long egressBytesTransferred() {
        return this.innerProperties() == null ? null : this.innerProperties().egressBytesTransferred();
    }

    public Long ingressBytesTransferred() {
        return this.innerProperties() == null ? null : this.innerProperties().ingressBytesTransferred();
    }

    public SubResource peer() {
        return this.innerProperties() == null ? null : this.innerProperties().peer();
    }

    public VirtualNetworkGatewayConnectionInner withPeer(SubResource peer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withPeer(peer);
        return this;
    }

    public Boolean enableBgp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBgp();
    }

    public VirtualNetworkGatewayConnectionInner withEnableBgp(Boolean enableBgp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withEnableBgp(enableBgp);
        return this;
    }

    public List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayCustomBgpIpAddresses();
    }

    public VirtualNetworkGatewayConnectionInner withGatewayCustomBgpIpAddresses(List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withGatewayCustomBgpIpAddresses(gatewayCustomBgpIpAddresses);
        return this;
    }

    public Boolean useLocalAzureIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().useLocalAzureIpAddress();
    }

    public VirtualNetworkGatewayConnectionInner withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withUseLocalAzureIpAddress(useLocalAzureIpAddress);
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().usePolicyBasedTrafficSelectors();
    }

    public VirtualNetworkGatewayConnectionInner withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withUsePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors);
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsecPolicies();
    }

    public VirtualNetworkGatewayConnectionInner withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withIpsecPolicies(ipsecPolicies);
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficSelectorPolicies();
    }

    public VirtualNetworkGatewayConnectionInner withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withTrafficSelectorPolicies(trafficSelectorPolicies);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean expressRouteGatewayBypass() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteGatewayBypass();
    }

    public VirtualNetworkGatewayConnectionInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withExpressRouteGatewayBypass(expressRouteGatewayBypass);
        return this;
    }

    public Boolean enablePrivateLinkFastPath() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePrivateLinkFastPath();
    }

    public VirtualNetworkGatewayConnectionInner withEnablePrivateLinkFastPath(Boolean enablePrivateLinkFastPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayConnectionPropertiesFormatInner();
        }
        this.innerProperties().withEnablePrivateLinkFastPath(enablePrivateLinkFastPath);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VirtualNetworkGatewayConnectionInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkGatewayConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkGatewayConnectionInner)((Object)jsonReader.readObject(reader -> {
            VirtualNetworkGatewayConnectionInner deserializedVirtualNetworkGatewayConnectionInner = new VirtualNetworkGatewayConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualNetworkGatewayConnectionInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.innerProperties = VirtualNetworkGatewayConnectionPropertiesFormatInner.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkGatewayConnectionInner;
        }));
    }
}

