/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class VirtualRouterPropertiesFormat
implements JsonSerializable<VirtualRouterPropertiesFormat> {
    private Long virtualRouterAsn;
    private List<String> virtualRouterIps;
    private SubResource hostedSubnet;
    private SubResource hostedGateway;
    private List<SubResource> peerings;
    private ProvisioningState provisioningState;

    public Long virtualRouterAsn() {
        return this.virtualRouterAsn;
    }

    public VirtualRouterPropertiesFormat withVirtualRouterAsn(Long virtualRouterAsn) {
        this.virtualRouterAsn = virtualRouterAsn;
        return this;
    }

    public List<String> virtualRouterIps() {
        return this.virtualRouterIps;
    }

    public VirtualRouterPropertiesFormat withVirtualRouterIps(List<String> virtualRouterIps) {
        this.virtualRouterIps = virtualRouterIps;
        return this;
    }

    public SubResource hostedSubnet() {
        return this.hostedSubnet;
    }

    public VirtualRouterPropertiesFormat withHostedSubnet(SubResource hostedSubnet) {
        this.hostedSubnet = hostedSubnet;
        return this;
    }

    public SubResource hostedGateway() {
        return this.hostedGateway;
    }

    public VirtualRouterPropertiesFormat withHostedGateway(SubResource hostedGateway) {
        this.hostedGateway = hostedGateway;
        return this;
    }

    public List<SubResource> peerings() {
        return this.peerings;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("virtualRouterAsn", (Number)this.virtualRouterAsn);
        jsonWriter.writeArrayField("virtualRouterIps", this.virtualRouterIps, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("hostedSubnet", (JsonSerializable)this.hostedSubnet);
        jsonWriter.writeJsonField("hostedGateway", (JsonSerializable)this.hostedGateway);
        return jsonWriter.writeEndObject();
    }

    public static VirtualRouterPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualRouterPropertiesFormat)jsonReader.readObject(reader -> {
            VirtualRouterPropertiesFormat deserializedVirtualRouterPropertiesFormat = new VirtualRouterPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualRouterAsn".equals(fieldName)) {
                    deserializedVirtualRouterPropertiesFormat.virtualRouterAsn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("virtualRouterIps".equals(fieldName)) {
                    List virtualRouterIps;
                    deserializedVirtualRouterPropertiesFormat.virtualRouterIps = virtualRouterIps = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hostedSubnet".equals(fieldName)) {
                    deserializedVirtualRouterPropertiesFormat.hostedSubnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("hostedGateway".equals(fieldName)) {
                    deserializedVirtualRouterPropertiesFormat.hostedGateway = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("peerings".equals(fieldName)) {
                    List peerings;
                    deserializedVirtualRouterPropertiesFormat.peerings = peerings = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualRouterPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualRouterPropertiesFormat;
        });
    }
}

