/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionState;
import com.azure.resourcemanager.network.models.ConnectivityHop;
import com.azure.resourcemanager.network.models.EvaluationState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ConnectionStateSnapshot
implements JsonSerializable<ConnectionStateSnapshot> {
    private ConnectionState connectionState;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private EvaluationState evaluationState;
    private Long avgLatencyInMs;
    private Long minLatencyInMs;
    private Long maxLatencyInMs;
    private Long probesSent;
    private Long probesFailed;
    private List<ConnectivityHop> hops;

    public ConnectionState connectionState() {
        return this.connectionState;
    }

    public ConnectionStateSnapshot withConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ConnectionStateSnapshot withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public ConnectionStateSnapshot withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public EvaluationState evaluationState() {
        return this.evaluationState;
    }

    public ConnectionStateSnapshot withEvaluationState(EvaluationState evaluationState) {
        this.evaluationState = evaluationState;
        return this;
    }

    public Long avgLatencyInMs() {
        return this.avgLatencyInMs;
    }

    public ConnectionStateSnapshot withAvgLatencyInMs(Long avgLatencyInMs) {
        this.avgLatencyInMs = avgLatencyInMs;
        return this;
    }

    public Long minLatencyInMs() {
        return this.minLatencyInMs;
    }

    public ConnectionStateSnapshot withMinLatencyInMs(Long minLatencyInMs) {
        this.minLatencyInMs = minLatencyInMs;
        return this;
    }

    public Long maxLatencyInMs() {
        return this.maxLatencyInMs;
    }

    public ConnectionStateSnapshot withMaxLatencyInMs(Long maxLatencyInMs) {
        this.maxLatencyInMs = maxLatencyInMs;
        return this;
    }

    public Long probesSent() {
        return this.probesSent;
    }

    public ConnectionStateSnapshot withProbesSent(Long probesSent) {
        this.probesSent = probesSent;
        return this;
    }

    public Long probesFailed() {
        return this.probesFailed;
    }

    public ConnectionStateSnapshot withProbesFailed(Long probesFailed) {
        this.probesFailed = probesFailed;
        return this;
    }

    public List<ConnectivityHop> hops() {
        return this.hops;
    }

    public void validate() {
        if (this.hops() != null) {
            this.hops().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionState", this.connectionState == null ? null : this.connectionState.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("evaluationState", this.evaluationState == null ? null : this.evaluationState.toString());
        jsonWriter.writeNumberField("avgLatencyInMs", (Number)this.avgLatencyInMs);
        jsonWriter.writeNumberField("minLatencyInMs", (Number)this.minLatencyInMs);
        jsonWriter.writeNumberField("maxLatencyInMs", (Number)this.maxLatencyInMs);
        jsonWriter.writeNumberField("probesSent", (Number)this.probesSent);
        jsonWriter.writeNumberField("probesFailed", (Number)this.probesFailed);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionStateSnapshot fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionStateSnapshot)jsonReader.readObject(reader -> {
            ConnectionStateSnapshot deserializedConnectionStateSnapshot = new ConnectionStateSnapshot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionState".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.connectionState = ConnectionState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("evaluationState".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.evaluationState = EvaluationState.fromString(reader.getString());
                    continue;
                }
                if ("avgLatencyInMs".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.avgLatencyInMs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("minLatencyInMs".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.minLatencyInMs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxLatencyInMs".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.maxLatencyInMs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("probesSent".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.probesSent = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("probesFailed".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.probesFailed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("hops".equals(fieldName)) {
                    List hops;
                    deserializedConnectionStateSnapshot.hops = hops = reader.readArray(reader1 -> ConnectivityHop.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionStateSnapshot;
        });
    }
}

