/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.RouteMapMatchCondition;
import java.io.IOException;
import java.util.List;

public final class Criterion
implements JsonSerializable<Criterion> {
    private List<String> routePrefix;
    private List<String> community;
    private List<String> asPath;
    private RouteMapMatchCondition matchCondition;

    public List<String> routePrefix() {
        return this.routePrefix;
    }

    public Criterion withRoutePrefix(List<String> routePrefix) {
        this.routePrefix = routePrefix;
        return this;
    }

    public List<String> community() {
        return this.community;
    }

    public Criterion withCommunity(List<String> community) {
        this.community = community;
        return this;
    }

    public List<String> asPath() {
        return this.asPath;
    }

    public Criterion withAsPath(List<String> asPath) {
        this.asPath = asPath;
        return this;
    }

    public RouteMapMatchCondition matchCondition() {
        return this.matchCondition;
    }

    public Criterion withMatchCondition(RouteMapMatchCondition matchCondition) {
        this.matchCondition = matchCondition;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("routePrefix", this.routePrefix, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("community", this.community, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("asPath", this.asPath, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("matchCondition", this.matchCondition == null ? null : this.matchCondition.toString());
        return jsonWriter.writeEndObject();
    }

    public static Criterion fromJson(JsonReader jsonReader) throws IOException {
        return (Criterion)jsonReader.readObject(reader -> {
            Criterion deserializedCriterion = new Criterion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routePrefix".equals(fieldName)) {
                    List routePrefix;
                    deserializedCriterion.routePrefix = routePrefix = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("community".equals(fieldName)) {
                    List community;
                    deserializedCriterion.community = community = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("asPath".equals(fieldName)) {
                    List asPath;
                    deserializedCriterion.asPath = asPath = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("matchCondition".equals(fieldName)) {
                    deserializedCriterion.matchCondition = RouteMapMatchCondition.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCriterion;
        });
    }
}

