/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettingsDomainNameLabelScope;
import java.io.IOException;

public final class PublicIpAddressDnsSettings
implements JsonSerializable<PublicIpAddressDnsSettings> {
    private String domainNameLabel;
    private PublicIpAddressDnsSettingsDomainNameLabelScope domainNameLabelScope;
    private String fqdn;
    private String reverseFqdn;

    public String domainNameLabel() {
        return this.domainNameLabel;
    }

    public PublicIpAddressDnsSettings withDomainNameLabel(String domainNameLabel) {
        this.domainNameLabel = domainNameLabel;
        return this;
    }

    public PublicIpAddressDnsSettingsDomainNameLabelScope domainNameLabelScope() {
        return this.domainNameLabelScope;
    }

    public PublicIpAddressDnsSettings withDomainNameLabelScope(PublicIpAddressDnsSettingsDomainNameLabelScope domainNameLabelScope) {
        this.domainNameLabelScope = domainNameLabelScope;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public PublicIpAddressDnsSettings withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public String reverseFqdn() {
        return this.reverseFqdn;
    }

    public PublicIpAddressDnsSettings withReverseFqdn(String reverseFqdn) {
        this.reverseFqdn = reverseFqdn;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domainNameLabel", this.domainNameLabel);
        jsonWriter.writeStringField("domainNameLabelScope", this.domainNameLabelScope == null ? null : this.domainNameLabelScope.toString());
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeStringField("reverseFqdn", this.reverseFqdn);
        return jsonWriter.writeEndObject();
    }

    public static PublicIpAddressDnsSettings fromJson(JsonReader jsonReader) throws IOException {
        return (PublicIpAddressDnsSettings)jsonReader.readObject(reader -> {
            PublicIpAddressDnsSettings deserializedPublicIpAddressDnsSettings = new PublicIpAddressDnsSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domainNameLabel".equals(fieldName)) {
                    deserializedPublicIpAddressDnsSettings.domainNameLabel = reader.getString();
                    continue;
                }
                if ("domainNameLabelScope".equals(fieldName)) {
                    deserializedPublicIpAddressDnsSettings.domainNameLabelScope = PublicIpAddressDnsSettingsDomainNameLabelScope.fromString(reader.getString());
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedPublicIpAddressDnsSettings.fqdn = reader.getString();
                    continue;
                }
                if ("reverseFqdn".equals(fieldName)) {
                    deserializedPublicIpAddressDnsSettings.reverseFqdn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPublicIpAddressDnsSettings;
        });
    }
}

