/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import java.io.IOException;
import java.util.List;

public final class SubnetAssociation
implements JsonSerializable<SubnetAssociation> {
    private String id;
    private List<SecurityRuleInner> securityRules;

    public String id() {
        return this.id;
    }

    public List<SecurityRuleInner> securityRules() {
        return this.securityRules;
    }

    public SubnetAssociation withSecurityRules(List<SecurityRuleInner> securityRules) {
        this.securityRules = securityRules;
        return this;
    }

    public void validate() {
        if (this.securityRules() != null) {
            this.securityRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("securityRules", this.securityRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SubnetAssociation fromJson(JsonReader jsonReader) throws IOException {
        return (SubnetAssociation)jsonReader.readObject(reader -> {
            SubnetAssociation deserializedSubnetAssociation = new SubnetAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSubnetAssociation.id = reader.getString();
                    continue;
                }
                if ("securityRules".equals(fieldName)) {
                    List securityRules;
                    deserializedSubnetAssociation.securityRules = securityRules = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubnetAssociation;
        });
    }
}

