/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class VpnClientConnectionHealth
implements JsonSerializable<VpnClientConnectionHealth> {
    private Long totalIngressBytesTransferred;
    private Long totalEgressBytesTransferred;
    private Integer vpnClientConnectionsCount;
    private List<String> allocatedIpAddresses;

    public Long totalIngressBytesTransferred() {
        return this.totalIngressBytesTransferred;
    }

    public Long totalEgressBytesTransferred() {
        return this.totalEgressBytesTransferred;
    }

    public Integer vpnClientConnectionsCount() {
        return this.vpnClientConnectionsCount;
    }

    public VpnClientConnectionHealth withVpnClientConnectionsCount(Integer vpnClientConnectionsCount) {
        this.vpnClientConnectionsCount = vpnClientConnectionsCount;
        return this;
    }

    public List<String> allocatedIpAddresses() {
        return this.allocatedIpAddresses;
    }

    public VpnClientConnectionHealth withAllocatedIpAddresses(List<String> allocatedIpAddresses) {
        this.allocatedIpAddresses = allocatedIpAddresses;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("vpnClientConnectionsCount", (Number)this.vpnClientConnectionsCount);
        jsonWriter.writeArrayField("allocatedIpAddresses", this.allocatedIpAddresses, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VpnClientConnectionHealth fromJson(JsonReader jsonReader) throws IOException {
        return (VpnClientConnectionHealth)jsonReader.readObject(reader -> {
            VpnClientConnectionHealth deserializedVpnClientConnectionHealth = new VpnClientConnectionHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("totalIngressBytesTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealth.totalIngressBytesTransferred = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalEgressBytesTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealth.totalEgressBytesTransferred = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("vpnClientConnectionsCount".equals(fieldName)) {
                    deserializedVpnClientConnectionHealth.vpnClientConnectionsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allocatedIpAddresses".equals(fieldName)) {
                    List allocatedIpAddresses;
                    deserializedVpnClientConnectionHealth.allocatedIpAddresses = allocatedIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnClientConnectionHealth;
        });
    }
}

