/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkManagerSecurityGroupItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class AdminRuleCollectionPropertiesFormat
implements JsonSerializable<AdminRuleCollectionPropertiesFormat> {
    private String description;
    private List<NetworkManagerSecurityGroupItem> appliesToGroups;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(AdminRuleCollectionPropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public AdminRuleCollectionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<NetworkManagerSecurityGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    public AdminRuleCollectionPropertiesFormat withAppliesToGroups(List<NetworkManagerSecurityGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.appliesToGroups() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appliesToGroups in model AdminRuleCollectionPropertiesFormat"));
        }
        this.appliesToGroups().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appliesToGroups", this.appliesToGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static AdminRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (AdminRuleCollectionPropertiesFormat)jsonReader.readObject(reader -> {
            AdminRuleCollectionPropertiesFormat deserializedAdminRuleCollectionPropertiesFormat = new AdminRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appliesToGroups".equals(fieldName)) {
                    List appliesToGroups;
                    deserializedAdminRuleCollectionPropertiesFormat.appliesToGroups = appliesToGroups = reader.readArray(reader1 -> NetworkManagerSecurityGroupItem.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAdminRuleCollectionPropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAdminRuleCollectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedAdminRuleCollectionPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdminRuleCollectionPropertiesFormat;
        });
    }
}

