/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class DefaultAdminPropertiesFormat
implements JsonSerializable<DefaultAdminPropertiesFormat> {
    private String description;
    private String flag;
    private SecurityConfigurationRuleProtocol protocol;
    private List<AddressPrefixItem> sources;
    private List<AddressPrefixItem> destinations;
    private List<String> sourcePortRanges;
    private List<String> destinationPortRanges;
    private SecurityConfigurationRuleAccess access;
    private Integer priority;
    private SecurityConfigurationRuleDirection direction;
    private ProvisioningState provisioningState;
    private String resourceGuid;

    public String description() {
        return this.description;
    }

    public String flag() {
        return this.flag;
    }

    public DefaultAdminPropertiesFormat withFlag(String flag) {
        this.flag = flag;
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.protocol;
    }

    public List<AddressPrefixItem> sources() {
        return this.sources;
    }

    public List<AddressPrefixItem> destinations() {
        return this.destinations;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public SecurityConfigurationRuleAccess access() {
        return this.access;
    }

    public Integer priority() {
        return this.priority;
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.direction;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.sources() != null) {
            this.sources().forEach(e -> e.validate());
        }
        if (this.destinations() != null) {
            this.destinations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("flag", this.flag);
        return jsonWriter.writeEndObject();
    }

    public static DefaultAdminPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultAdminPropertiesFormat)jsonReader.readObject(reader -> {
            DefaultAdminPropertiesFormat deserializedDefaultAdminPropertiesFormat = new DefaultAdminPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("flag".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.flag = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.protocol = SecurityConfigurationRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("sources".equals(fieldName)) {
                    List sources;
                    deserializedDefaultAdminPropertiesFormat.sources = sources = reader.readArray(reader1 -> AddressPrefixItem.fromJson(reader1));
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    List destinations;
                    deserializedDefaultAdminPropertiesFormat.destinations = destinations = reader.readArray(reader1 -> AddressPrefixItem.fromJson(reader1));
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List sourcePortRanges;
                    deserializedDefaultAdminPropertiesFormat.sourcePortRanges = sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List destinationPortRanges;
                    deserializedDefaultAdminPropertiesFormat.destinationPortRanges = destinationPortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.access = SecurityConfigurationRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.direction = SecurityConfigurationRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedDefaultAdminPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultAdminPropertiesFormat;
        });
    }
}

