/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationPropertiesFormatInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class FrontendIpConfigurationInner
extends SubResource {
    private FrontendIpConfigurationPropertiesFormatInner innerProperties;
    private String name;
    private String etag;
    private String type;
    private List<String> zones;

    private FrontendIpConfigurationPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public FrontendIpConfigurationInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public List<String> zones() {
        return this.zones;
    }

    public FrontendIpConfigurationInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public FrontendIpConfigurationInner withId(String id) {
        super.withId(id);
        return this;
    }

    public List<SubResource> inboundNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatRules();
    }

    public List<SubResource> inboundNatPools() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatPools();
    }

    public List<SubResource> outboundRules() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRules();
    }

    public List<SubResource> loadBalancingRules() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingRules();
    }

    public String privateIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddress();
    }

    public FrontendIpConfigurationInner withPrivateIpAddress(String privateIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withPrivateIpAddress(privateIpAddress);
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAllocationMethod();
    }

    public FrontendIpConfigurationInner withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withPrivateIpAllocationMethod(privateIpAllocationMethod);
        return this;
    }

    public IpVersion privateIpAddressVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddressVersion();
    }

    public FrontendIpConfigurationInner withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withPrivateIpAddressVersion(privateIpAddressVersion);
        return this;
    }

    public SubnetInner subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public FrontendIpConfigurationInner withSubnet(SubnetInner subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public PublicIpAddressInner publicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddress();
    }

    public FrontendIpConfigurationInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpAddress(publicIpAddress);
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefix();
    }

    public FrontendIpConfigurationInner withPublicIpPrefix(SubResource publicIpPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpPrefix(publicIpPrefix);
        return this;
    }

    public SubResource gatewayLoadBalancer() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayLoadBalancer();
    }

    public FrontendIpConfigurationInner withGatewayLoadBalancer(SubResource gatewayLoadBalancer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendIpConfigurationPropertiesFormatInner();
        }
        this.innerProperties().withGatewayLoadBalancer(gatewayLoadBalancer);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FrontendIpConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (FrontendIpConfigurationInner)((Object)jsonReader.readObject(reader -> {
            FrontendIpConfigurationInner deserializedFrontendIpConfigurationInner = new FrontendIpConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFrontendIpConfigurationInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFrontendIpConfigurationInner.innerProperties = FrontendIpConfigurationPropertiesFormatInner.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFrontendIpConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedFrontendIpConfigurationInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFrontendIpConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedFrontendIpConfigurationInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFrontendIpConfigurationInner;
        }));
    }
}

