/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class IpConfigurationPropertiesFormatInner
implements JsonSerializable<IpConfigurationPropertiesFormatInner> {
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;
    private SubnetInner subnet;
    private PublicIpAddressInner publicIpAddress;
    private ProvisioningState provisioningState;

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public IpConfigurationPropertiesFormatInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public IpConfigurationPropertiesFormatInner withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public SubnetInner subnet() {
        return this.subnet;
    }

    public IpConfigurationPropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    public IpConfigurationPropertiesFormatInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.publicIpAddress() != null) {
            this.publicIpAddress().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", (JsonSerializable)this.publicIpAddress);
        return jsonWriter.writeEndObject();
    }

    public static IpConfigurationPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (IpConfigurationPropertiesFormatInner)jsonReader.readObject(reader -> {
            IpConfigurationPropertiesFormatInner deserializedIpConfigurationPropertiesFormatInner = new IpConfigurationPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedIpConfigurationPropertiesFormatInner.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedIpConfigurationPropertiesFormatInner.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedIpConfigurationPropertiesFormatInner.subnet = SubnetInner.fromJson(reader);
                    continue;
                }
                if ("publicIPAddress".equals(fieldName)) {
                    deserializedIpConfigurationPropertiesFormatInner.publicIpAddress = PublicIpAddressInner.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedIpConfigurationPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpConfigurationPropertiesFormatInner;
        });
    }
}

