/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NatGatewayPropertiesFormat
implements JsonSerializable<NatGatewayPropertiesFormat> {
    private Integer idleTimeoutInMinutes;
    private List<SubResource> publicIpAddresses;
    private List<SubResource> publicIpPrefixes;
    private List<SubResource> subnets;
    private String resourceGuid;
    private ProvisioningState provisioningState;

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public NatGatewayPropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public List<SubResource> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    public NatGatewayPropertiesFormat withPublicIpAddresses(List<SubResource> publicIpAddresses) {
        this.publicIpAddresses = publicIpAddresses;
        return this;
    }

    public List<SubResource> publicIpPrefixes() {
        return this.publicIpPrefixes;
    }

    public NatGatewayPropertiesFormat withPublicIpPrefixes(List<SubResource> publicIpPrefixes) {
        this.publicIpPrefixes = publicIpPrefixes;
        return this;
    }

    public List<SubResource> subnets() {
        return this.subnets;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeArrayField("publicIpAddresses", this.publicIpAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("publicIpPrefixes", this.publicIpPrefixes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NatGatewayPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (NatGatewayPropertiesFormat)jsonReader.readObject(reader -> {
            NatGatewayPropertiesFormat deserializedNatGatewayPropertiesFormat = new NatGatewayPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedNatGatewayPropertiesFormat.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("publicIpAddresses".equals(fieldName)) {
                    List publicIpAddresses;
                    deserializedNatGatewayPropertiesFormat.publicIpAddresses = publicIpAddresses = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("publicIpPrefixes".equals(fieldName)) {
                    List publicIpPrefixes;
                    deserializedNatGatewayPropertiesFormat.publicIpPrefixes = publicIpPrefixes = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List subnets;
                    deserializedNatGatewayPropertiesFormat.subnets = subnets = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedNatGatewayPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNatGatewayPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNatGatewayPropertiesFormat;
        });
    }
}

