/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.azure.resourcemanager.network.models.VirtualNetworkEncryption;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringLevel;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringState;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkPeeringPropertiesFormat
implements JsonSerializable<VirtualNetworkPeeringPropertiesFormat> {
    private Boolean allowVirtualNetworkAccess;
    private Boolean allowForwardedTraffic;
    private Boolean allowGatewayTransit;
    private Boolean useRemoteGateways;
    private SubResource remoteVirtualNetwork;
    private AddressSpace localAddressSpace;
    private AddressSpace localVirtualNetworkAddressSpace;
    private AddressSpace remoteAddressSpace;
    private AddressSpace remoteVirtualNetworkAddressSpace;
    private VirtualNetworkBgpCommunities remoteBgpCommunities;
    private VirtualNetworkEncryption remoteVirtualNetworkEncryption;
    private VirtualNetworkPeeringState peeringState;
    private VirtualNetworkPeeringLevel peeringSyncLevel;
    private ProvisioningState provisioningState;
    private Boolean doNotVerifyRemoteGateways;
    private String resourceGuid;
    private Boolean peerCompleteVnets;
    private Boolean enableOnlyIPv6Peering;
    private List<String> localSubnetNames;
    private List<String> remoteSubnetNames;

    public Boolean allowVirtualNetworkAccess() {
        return this.allowVirtualNetworkAccess;
    }

    public VirtualNetworkPeeringPropertiesFormat withAllowVirtualNetworkAccess(Boolean allowVirtualNetworkAccess) {
        this.allowVirtualNetworkAccess = allowVirtualNetworkAccess;
        return this;
    }

    public Boolean allowForwardedTraffic() {
        return this.allowForwardedTraffic;
    }

    public VirtualNetworkPeeringPropertiesFormat withAllowForwardedTraffic(Boolean allowForwardedTraffic) {
        this.allowForwardedTraffic = allowForwardedTraffic;
        return this;
    }

    public Boolean allowGatewayTransit() {
        return this.allowGatewayTransit;
    }

    public VirtualNetworkPeeringPropertiesFormat withAllowGatewayTransit(Boolean allowGatewayTransit) {
        this.allowGatewayTransit = allowGatewayTransit;
        return this;
    }

    public Boolean useRemoteGateways() {
        return this.useRemoteGateways;
    }

    public VirtualNetworkPeeringPropertiesFormat withUseRemoteGateways(Boolean useRemoteGateways) {
        this.useRemoteGateways = useRemoteGateways;
        return this;
    }

    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    public AddressSpace localAddressSpace() {
        return this.localAddressSpace;
    }

    public VirtualNetworkPeeringPropertiesFormat withLocalAddressSpace(AddressSpace localAddressSpace) {
        this.localAddressSpace = localAddressSpace;
        return this;
    }

    public AddressSpace localVirtualNetworkAddressSpace() {
        return this.localVirtualNetworkAddressSpace;
    }

    public VirtualNetworkPeeringPropertiesFormat withLocalVirtualNetworkAddressSpace(AddressSpace localVirtualNetworkAddressSpace) {
        this.localVirtualNetworkAddressSpace = localVirtualNetworkAddressSpace;
        return this;
    }

    public AddressSpace remoteAddressSpace() {
        return this.remoteAddressSpace;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteAddressSpace(AddressSpace remoteAddressSpace) {
        this.remoteAddressSpace = remoteAddressSpace;
        return this;
    }

    public AddressSpace remoteVirtualNetworkAddressSpace() {
        return this.remoteVirtualNetworkAddressSpace;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteVirtualNetworkAddressSpace(AddressSpace remoteVirtualNetworkAddressSpace) {
        this.remoteVirtualNetworkAddressSpace = remoteVirtualNetworkAddressSpace;
        return this;
    }

    public VirtualNetworkBgpCommunities remoteBgpCommunities() {
        return this.remoteBgpCommunities;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteBgpCommunities(VirtualNetworkBgpCommunities remoteBgpCommunities) {
        this.remoteBgpCommunities = remoteBgpCommunities;
        return this;
    }

    public VirtualNetworkEncryption remoteVirtualNetworkEncryption() {
        return this.remoteVirtualNetworkEncryption;
    }

    public VirtualNetworkPeeringState peeringState() {
        return this.peeringState;
    }

    public VirtualNetworkPeeringPropertiesFormat withPeeringState(VirtualNetworkPeeringState peeringState) {
        this.peeringState = peeringState;
        return this;
    }

    public VirtualNetworkPeeringLevel peeringSyncLevel() {
        return this.peeringSyncLevel;
    }

    public VirtualNetworkPeeringPropertiesFormat withPeeringSyncLevel(VirtualNetworkPeeringLevel peeringSyncLevel) {
        this.peeringSyncLevel = peeringSyncLevel;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean doNotVerifyRemoteGateways() {
        return this.doNotVerifyRemoteGateways;
    }

    public VirtualNetworkPeeringPropertiesFormat withDoNotVerifyRemoteGateways(Boolean doNotVerifyRemoteGateways) {
        this.doNotVerifyRemoteGateways = doNotVerifyRemoteGateways;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public Boolean peerCompleteVnets() {
        return this.peerCompleteVnets;
    }

    public VirtualNetworkPeeringPropertiesFormat withPeerCompleteVnets(Boolean peerCompleteVnets) {
        this.peerCompleteVnets = peerCompleteVnets;
        return this;
    }

    public Boolean enableOnlyIPv6Peering() {
        return this.enableOnlyIPv6Peering;
    }

    public VirtualNetworkPeeringPropertiesFormat withEnableOnlyIPv6Peering(Boolean enableOnlyIPv6Peering) {
        this.enableOnlyIPv6Peering = enableOnlyIPv6Peering;
        return this;
    }

    public List<String> localSubnetNames() {
        return this.localSubnetNames;
    }

    public VirtualNetworkPeeringPropertiesFormat withLocalSubnetNames(List<String> localSubnetNames) {
        this.localSubnetNames = localSubnetNames;
        return this;
    }

    public List<String> remoteSubnetNames() {
        return this.remoteSubnetNames;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteSubnetNames(List<String> remoteSubnetNames) {
        this.remoteSubnetNames = remoteSubnetNames;
        return this;
    }

    public void validate() {
        if (this.localAddressSpace() != null) {
            this.localAddressSpace().validate();
        }
        if (this.localVirtualNetworkAddressSpace() != null) {
            this.localVirtualNetworkAddressSpace().validate();
        }
        if (this.remoteAddressSpace() != null) {
            this.remoteAddressSpace().validate();
        }
        if (this.remoteVirtualNetworkAddressSpace() != null) {
            this.remoteVirtualNetworkAddressSpace().validate();
        }
        if (this.remoteBgpCommunities() != null) {
            this.remoteBgpCommunities().validate();
        }
        if (this.remoteVirtualNetworkEncryption() != null) {
            this.remoteVirtualNetworkEncryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowVirtualNetworkAccess", this.allowVirtualNetworkAccess);
        jsonWriter.writeBooleanField("allowForwardedTraffic", this.allowForwardedTraffic);
        jsonWriter.writeBooleanField("allowGatewayTransit", this.allowGatewayTransit);
        jsonWriter.writeBooleanField("useRemoteGateways", this.useRemoteGateways);
        jsonWriter.writeJsonField("remoteVirtualNetwork", (JsonSerializable)this.remoteVirtualNetwork);
        jsonWriter.writeJsonField("localAddressSpace", (JsonSerializable)this.localAddressSpace);
        jsonWriter.writeJsonField("localVirtualNetworkAddressSpace", (JsonSerializable)this.localVirtualNetworkAddressSpace);
        jsonWriter.writeJsonField("remoteAddressSpace", (JsonSerializable)this.remoteAddressSpace);
        jsonWriter.writeJsonField("remoteVirtualNetworkAddressSpace", (JsonSerializable)this.remoteVirtualNetworkAddressSpace);
        jsonWriter.writeJsonField("remoteBgpCommunities", (JsonSerializable)this.remoteBgpCommunities);
        jsonWriter.writeStringField("peeringState", this.peeringState == null ? null : this.peeringState.toString());
        jsonWriter.writeStringField("peeringSyncLevel", this.peeringSyncLevel == null ? null : this.peeringSyncLevel.toString());
        jsonWriter.writeBooleanField("doNotVerifyRemoteGateways", this.doNotVerifyRemoteGateways);
        jsonWriter.writeBooleanField("peerCompleteVnets", this.peerCompleteVnets);
        jsonWriter.writeBooleanField("enableOnlyIPv6Peering", this.enableOnlyIPv6Peering);
        jsonWriter.writeArrayField("localSubnetNames", this.localSubnetNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("remoteSubnetNames", this.remoteSubnetNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkPeeringPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkPeeringPropertiesFormat)jsonReader.readObject(reader -> {
            VirtualNetworkPeeringPropertiesFormat deserializedVirtualNetworkPeeringPropertiesFormat = new VirtualNetworkPeeringPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowVirtualNetworkAccess".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.allowVirtualNetworkAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowForwardedTraffic".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.allowForwardedTraffic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowGatewayTransit".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.allowGatewayTransit = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("useRemoteGateways".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.useRemoteGateways = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("remoteVirtualNetwork".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.remoteVirtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("localAddressSpace".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.localAddressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("localVirtualNetworkAddressSpace".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.localVirtualNetworkAddressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("remoteAddressSpace".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.remoteAddressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("remoteVirtualNetworkAddressSpace".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.remoteVirtualNetworkAddressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("remoteBgpCommunities".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.remoteBgpCommunities = VirtualNetworkBgpCommunities.fromJson(reader);
                    continue;
                }
                if ("remoteVirtualNetworkEncryption".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.remoteVirtualNetworkEncryption = VirtualNetworkEncryption.fromJson(reader);
                    continue;
                }
                if ("peeringState".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.peeringState = VirtualNetworkPeeringState.fromString(reader.getString());
                    continue;
                }
                if ("peeringSyncLevel".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.peeringSyncLevel = VirtualNetworkPeeringLevel.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("doNotVerifyRemoteGateways".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.doNotVerifyRemoteGateways = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("peerCompleteVnets".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.peerCompleteVnets = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableOnlyIPv6Peering".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringPropertiesFormat.enableOnlyIPv6Peering = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("localSubnetNames".equals(fieldName)) {
                    List localSubnetNames;
                    deserializedVirtualNetworkPeeringPropertiesFormat.localSubnetNames = localSubnetNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("remoteSubnetNames".equals(fieldName)) {
                    List remoteSubnetNames;
                    deserializedVirtualNetworkPeeringPropertiesFormat.remoteSubnetNames = remoteSubnetNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkPeeringPropertiesFormat;
        });
    }
}

