/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AzureFirewallApplicationRuleCollectionPropertiesFormat;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRule;
import com.azure.resourcemanager.network.models.AzureFirewallRCAction;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class AzureFirewallApplicationRuleCollection
extends SubResource {
    private AzureFirewallApplicationRuleCollectionPropertiesFormat innerProperties;
    private String name;
    private String etag;

    private AzureFirewallApplicationRuleCollectionPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public AzureFirewallApplicationRuleCollection withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public AzureFirewallApplicationRuleCollection withId(String id) {
        super.withId(id);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public AzureFirewallApplicationRuleCollection withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallApplicationRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public AzureFirewallRCAction action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    public AzureFirewallApplicationRuleCollection withAction(AzureFirewallRCAction action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallApplicationRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    public List<AzureFirewallApplicationRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public AzureFirewallApplicationRuleCollection withRules(List<AzureFirewallApplicationRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallApplicationRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallApplicationRuleCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFirewallApplicationRuleCollection)((Object)jsonReader.readObject(reader -> {
            AzureFirewallApplicationRuleCollection deserializedAzureFirewallApplicationRuleCollection = new AzureFirewallApplicationRuleCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollection.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollection.innerProperties = AzureFirewallApplicationRuleCollectionPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollection.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollection.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallApplicationRuleCollection;
        }));
    }
}

