/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import reactor.core.publisher.Mono;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final String SDK_NAME_KEY = "Sdk-Name";
    private static final String SDK_VERSION_KEY = "Sdk-Version";
    private static final String APPLICATION_ID_KEY = "Application-Id";
    private final String defaultSdkName = this.getClass().getPackage().getName();
    private final String defaultSdkVersion = this.getClass().getPackage().getSpecificationVersion();
    private final HttpLogOptions httpLogOptions;
    private final Configuration configuration;

    public UserAgentPolicy(HttpLogOptions httpLogOptions, Configuration configuration) {
        this.httpLogOptions = httpLogOptions == null ? new HttpLogOptions() : httpLogOptions;
        this.configuration = configuration == null ? Configuration.getGlobalConfiguration() : configuration;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String applicationId;
        String sdkVersion;
        String userAgent = context.getHttpRequest().getHeaders().getValue(USER_AGENT_KEY);
        if (!CoreUtils.isNullOrEmpty((CharSequence)userAgent)) {
            return next.process();
        }
        userAgent = context.getData(USER_AGENT_KEY).orElse("").toString();
        if (!CoreUtils.isNullOrEmpty((CharSequence)userAgent)) {
            context.getHttpRequest().setHeader(USER_AGENT_KEY, userAgent);
            return next.process();
        }
        String sdkName = context.getData(SDK_NAME_KEY).orElse("").toString();
        if (CoreUtils.isNullOrEmpty((CharSequence)sdkName)) {
            sdkName = this.defaultSdkName;
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)(sdkVersion = context.getData(SDK_VERSION_KEY).orElse("").toString()))) {
            sdkVersion = this.defaultSdkVersion;
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)(applicationId = context.getData(APPLICATION_ID_KEY).orElse("").toString()))) {
            applicationId = this.httpLogOptions.getApplicationId();
        }
        context.getHttpRequest().setHeader(USER_AGENT_KEY, UserAgentUtil.toUserAgentString((String)applicationId, (String)sdkName, (String)sdkVersion, (Configuration)this.configuration));
        return next.process();
    }
}

