/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.ActionOnUnmanage;
import com.azure.resourcemanager.resources.models.DenySettings;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentStackProvisioningState;
import com.azure.resourcemanager.resources.models.DeploymentStacksDebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentStacksParametersLink;
import com.azure.resourcemanager.resources.models.DeploymentStacksTemplateLink;
import com.azure.resourcemanager.resources.models.ManagedResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReferenceExtended;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class DeploymentStackProperties {
    @JsonProperty(value="template")
    private Object template;
    @JsonProperty(value="templateLink")
    private DeploymentStacksTemplateLink templateLink;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, DeploymentParameter> parameters;
    @JsonProperty(value="parametersLink")
    private DeploymentStacksParametersLink parametersLink;
    @JsonProperty(value="actionOnUnmanage", required=true)
    private ActionOnUnmanage actionOnUnmanage;
    @JsonProperty(value="debugSetting")
    private DeploymentStacksDebugSetting debugSetting;
    @JsonProperty(value="bypassStackOutOfSyncError")
    private Boolean bypassStackOutOfSyncError;
    @JsonProperty(value="deploymentScope")
    private String deploymentScope;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="denySettings", required=true)
    private DenySettings denySettings;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStackProvisioningState provisioningState;
    @JsonProperty(value="correlationId", access=JsonProperty.Access.WRITE_ONLY)
    private String correlationId;
    @JsonProperty(value="detachedResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceReference> detachedResources;
    @JsonProperty(value="deletedResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceReference> deletedResources;
    @JsonProperty(value="failedResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceReferenceExtended> failedResources;
    @JsonProperty(value="resources", access=JsonProperty.Access.WRITE_ONLY)
    private List<ManagedResourceReference> resources;
    @JsonProperty(value="deploymentId", access=JsonProperty.Access.WRITE_ONLY)
    private String deploymentId;
    @JsonProperty(value="outputs", access=JsonProperty.Access.WRITE_ONLY)
    private Object outputs;
    @JsonProperty(value="duration", access=JsonProperty.Access.WRITE_ONLY)
    private String duration;
    @JsonProperty(value="error")
    private ManagementError error;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentStackProperties.class);

    public Object template() {
        return this.template;
    }

    public DeploymentStackProperties withTemplate(Object template) {
        this.template = template;
        return this;
    }

    public DeploymentStacksTemplateLink templateLink() {
        return this.templateLink;
    }

    public DeploymentStackProperties withTemplateLink(DeploymentStacksTemplateLink templateLink) {
        this.templateLink = templateLink;
        return this;
    }

    public Map<String, DeploymentParameter> parameters() {
        return this.parameters;
    }

    public DeploymentStackProperties withParameters(Map<String, DeploymentParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public DeploymentStacksParametersLink parametersLink() {
        return this.parametersLink;
    }

    public DeploymentStackProperties withParametersLink(DeploymentStacksParametersLink parametersLink) {
        this.parametersLink = parametersLink;
        return this;
    }

    public ActionOnUnmanage actionOnUnmanage() {
        return this.actionOnUnmanage;
    }

    public DeploymentStackProperties withActionOnUnmanage(ActionOnUnmanage actionOnUnmanage) {
        this.actionOnUnmanage = actionOnUnmanage;
        return this;
    }

    public DeploymentStacksDebugSetting debugSetting() {
        return this.debugSetting;
    }

    public DeploymentStackProperties withDebugSetting(DeploymentStacksDebugSetting debugSetting) {
        this.debugSetting = debugSetting;
        return this;
    }

    public Boolean bypassStackOutOfSyncError() {
        return this.bypassStackOutOfSyncError;
    }

    public DeploymentStackProperties withBypassStackOutOfSyncError(Boolean bypassStackOutOfSyncError) {
        this.bypassStackOutOfSyncError = bypassStackOutOfSyncError;
        return this;
    }

    public String deploymentScope() {
        return this.deploymentScope;
    }

    public DeploymentStackProperties withDeploymentScope(String deploymentScope) {
        this.deploymentScope = deploymentScope;
        return this;
    }

    public String description() {
        return this.description;
    }

    public DeploymentStackProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public DenySettings denySettings() {
        return this.denySettings;
    }

    public DeploymentStackProperties withDenySettings(DenySettings denySettings) {
        this.denySettings = denySettings;
        return this;
    }

    public DeploymentStackProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public List<ResourceReference> detachedResources() {
        return this.detachedResources;
    }

    public List<ResourceReference> deletedResources() {
        return this.deletedResources;
    }

    public List<ResourceReferenceExtended> failedResources() {
        return this.failedResources;
    }

    public List<ManagedResourceReference> resources() {
        return this.resources;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public Object outputs() {
        return this.outputs;
    }

    public String duration() {
        return this.duration;
    }

    public ManagementError error() {
        return this.error;
    }

    public DeploymentStackProperties withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.templateLink() != null) {
            this.templateLink().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.parametersLink() != null) {
            this.parametersLink().validate();
        }
        if (this.actionOnUnmanage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actionOnUnmanage in model DeploymentStackProperties"));
        }
        this.actionOnUnmanage().validate();
        if (this.debugSetting() != null) {
            this.debugSetting().validate();
        }
        if (this.denySettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property denySettings in model DeploymentStackProperties"));
        }
        this.denySettings().validate();
        if (this.detachedResources() != null) {
            this.detachedResources().forEach(e -> e.validate());
        }
        if (this.deletedResources() != null) {
            this.deletedResources().forEach(e -> e.validate());
        }
        if (this.failedResources() != null) {
            this.failedResources().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
    }
}

