/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackProperties;
import com.azure.resourcemanager.resources.models.ActionOnUnmanage;
import com.azure.resourcemanager.resources.models.AzureResourceBase;
import com.azure.resourcemanager.resources.models.DenySettings;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentStackProvisioningState;
import com.azure.resourcemanager.resources.models.DeploymentStacksDebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentStacksParametersLink;
import com.azure.resourcemanager.resources.models.DeploymentStacksTemplateLink;
import com.azure.resourcemanager.resources.models.ManagedResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReferenceExtended;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DeploymentStackInner
extends AzureResourceBase {
    private String location;
    private Map<String, String> tags;
    private DeploymentStackProperties innerProperties;
    private String id;
    private String name;
    private String type;
    private SystemData systemData;

    public String location() {
        return this.location;
    }

    public DeploymentStackInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DeploymentStackInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private DeploymentStackProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    public Object template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public DeploymentStackInner withTemplate(Object template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public DeploymentStacksTemplateLink templateLink() {
        return this.innerProperties() == null ? null : this.innerProperties().templateLink();
    }

    public DeploymentStackInner withTemplateLink(DeploymentStacksTemplateLink templateLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withTemplateLink(templateLink);
        return this;
    }

    public Map<String, DeploymentParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public DeploymentStackInner withParameters(Map<String, DeploymentParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public DeploymentStacksParametersLink parametersLink() {
        return this.innerProperties() == null ? null : this.innerProperties().parametersLink();
    }

    public DeploymentStackInner withParametersLink(DeploymentStacksParametersLink parametersLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withParametersLink(parametersLink);
        return this;
    }

    public ActionOnUnmanage actionOnUnmanage() {
        return this.innerProperties() == null ? null : this.innerProperties().actionOnUnmanage();
    }

    public DeploymentStackInner withActionOnUnmanage(ActionOnUnmanage actionOnUnmanage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withActionOnUnmanage(actionOnUnmanage);
        return this;
    }

    public DeploymentStacksDebugSetting debugSetting() {
        return this.innerProperties() == null ? null : this.innerProperties().debugSetting();
    }

    public DeploymentStackInner withDebugSetting(DeploymentStacksDebugSetting debugSetting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDebugSetting(debugSetting);
        return this;
    }

    public Boolean bypassStackOutOfSyncError() {
        return this.innerProperties() == null ? null : this.innerProperties().bypassStackOutOfSyncError();
    }

    public DeploymentStackInner withBypassStackOutOfSyncError(Boolean bypassStackOutOfSyncError) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withBypassStackOutOfSyncError(bypassStackOutOfSyncError);
        return this;
    }

    public String deploymentScope() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentScope();
    }

    public DeploymentStackInner withDeploymentScope(String deploymentScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDeploymentScope(deploymentScope);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public DeploymentStackInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public DenySettings denySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().denySettings();
    }

    public DeploymentStackInner withDenySettings(DenySettings denySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDenySettings(denySettings);
        return this;
    }

    public DeploymentStackProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    public List<ResourceReference> detachedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().detachedResources();
    }

    public List<ResourceReference> deletedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedResources();
    }

    public List<ResourceReferenceExtended> failedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().failedResources();
    }

    public List<ManagedResourceReference> resources() {
        return this.innerProperties() == null ? null : this.innerProperties().resources();
    }

    public String deploymentId() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentId();
    }

    public Object outputs() {
        return this.innerProperties() == null ? null : this.innerProperties().outputs();
    }

    public String duration() {
        return this.innerProperties() == null ? null : this.innerProperties().duration();
    }

    public ManagementError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public DeploymentStackInner withError(ManagementError error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentStackInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentStackInner)((Object)jsonReader.readObject(reader -> {
            DeploymentStackInner deserializedDeploymentStackInner = new DeploymentStackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeploymentStackInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeploymentStackInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeploymentStackInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDeploymentStackInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDeploymentStackInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeploymentStackInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentStackInner.innerProperties = DeploymentStackProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentStackInner;
        }));
    }
}

