/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ProviderAuthorizationConsentState;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import java.io.IOException;
import java.util.List;

public final class ProviderInner
implements JsonSerializable<ProviderInner> {
    private String id;
    private String namespace;
    private String registrationState;
    private String registrationPolicy;
    private List<ProviderResourceType> resourceTypes;
    private ProviderAuthorizationConsentState providerAuthorizationConsentState;

    public String id() {
        return this.id;
    }

    public String namespace() {
        return this.namespace;
    }

    public ProviderInner withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String registrationState() {
        return this.registrationState;
    }

    public String registrationPolicy() {
        return this.registrationPolicy;
    }

    public List<ProviderResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    public ProviderAuthorizationConsentState providerAuthorizationConsentState() {
        return this.providerAuthorizationConsentState;
    }

    public ProviderInner withProviderAuthorizationConsentState(ProviderAuthorizationConsentState providerAuthorizationConsentState) {
        this.providerAuthorizationConsentState = providerAuthorizationConsentState;
        return this;
    }

    public void validate() {
        if (this.resourceTypes() != null) {
            this.resourceTypes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("providerAuthorizationConsentState", this.providerAuthorizationConsentState == null ? null : this.providerAuthorizationConsentState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ProviderInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderInner)jsonReader.readObject(reader -> {
            ProviderInner deserializedProviderInner = new ProviderInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProviderInner.id = reader.getString();
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedProviderInner.namespace = reader.getString();
                    continue;
                }
                if ("registrationState".equals(fieldName)) {
                    deserializedProviderInner.registrationState = reader.getString();
                    continue;
                }
                if ("registrationPolicy".equals(fieldName)) {
                    deserializedProviderInner.registrationPolicy = reader.getString();
                    continue;
                }
                if ("resourceTypes".equals(fieldName)) {
                    List resourceTypes;
                    deserializedProviderInner.resourceTypes = resourceTypes = reader.readArray(reader1 -> ProviderResourceType.fromJson(reader1));
                    continue;
                }
                if ("providerAuthorizationConsentState".equals(fieldName)) {
                    deserializedProviderInner.providerAuthorizationConsentState = ProviderAuthorizationConsentState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderInner;
        });
    }
}

