/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.Tags;
import java.io.IOException;

public final class TagsResourceInner
extends ProxyResource {
    private Tags properties;
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(TagsResourceInner.class);

    public Tags properties() {
        return this.properties;
    }

    public TagsResourceInner withProperties(Tags properties) {
        this.properties = properties;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model TagsResourceInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static TagsResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (TagsResourceInner)((Object)jsonReader.readObject(reader -> {
            TagsResourceInner deserializedTagsResourceInner = new TagsResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTagsResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTagsResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTagsResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTagsResourceInner.properties = Tags.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagsResourceInner;
        }));
    }
}

