/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyType;
import java.io.IOException;
import java.util.Map;

public final class PolicyDefinitionProperties
implements JsonSerializable<PolicyDefinitionProperties> {
    private PolicyType policyType;
    private String mode;
    private String displayName;
    private String description;
    private Object policyRule;
    private Object metadata;
    private Map<String, ParameterDefinitionsValue> parameters;

    public PolicyType policyType() {
        return this.policyType;
    }

    public PolicyDefinitionProperties withPolicyType(PolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    public String mode() {
        return this.mode;
    }

    public PolicyDefinitionProperties withMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicyDefinitionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object policyRule() {
        return this.policyRule;
    }

    public PolicyDefinitionProperties withPolicyRule(Object policyRule) {
        this.policyRule = policyRule;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicyDefinitionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.parameters;
    }

    public PolicyDefinitionProperties withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyType", this.policyType == null ? null : this.policyType.toString());
        jsonWriter.writeStringField("mode", this.mode);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("policyRule", this.policyRule);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyDefinitionProperties)jsonReader.readObject(reader -> {
            PolicyDefinitionProperties deserializedPolicyDefinitionProperties = new PolicyDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyType".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.policyType = PolicyType.fromString(reader.getString());
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.mode = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.description = reader.getString();
                    continue;
                }
                if ("policyRule".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.policyRule = reader.readUntyped();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.metadata = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPolicyDefinitionProperties.parameters = parameters = reader.readMap(reader1 -> ParameterDefinitionsValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyDefinitionProperties;
        });
    }
}

