/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ResourceGroupProperties;
import java.io.IOException;
import java.util.Map;

public final class ResourceGroupInner
extends Resource {
    private ResourceGroupProperties properties;
    private String managedBy;
    private String id;
    private String name;
    private String type;

    public ResourceGroupProperties properties() {
        return this.properties;
    }

    public ResourceGroupInner withProperties(ResourceGroupProperties properties) {
        this.properties = properties;
        return this;
    }

    public String managedBy() {
        return this.managedBy;
    }

    public ResourceGroupInner withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ResourceGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ResourceGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("managedBy", this.managedBy);
        return jsonWriter.writeEndObject();
    }

    public static ResourceGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGroupInner)((Object)jsonReader.readObject(reader -> {
            ResourceGroupInner deserializedResourceGroupInner = new ResourceGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedResourceGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedResourceGroupInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceGroupInner.properties = ResourceGroupProperties.fromJson(reader);
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    deserializedResourceGroupInner.managedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGroupInner;
        }));
    }
}

