/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentProperties;
import com.azure.resourcemanager.resources.models.DeploymentWhatIfSettings;
import com.azure.resourcemanager.resources.models.ExpressionEvaluationOptions;
import com.azure.resourcemanager.resources.models.OnErrorDeployment;
import com.azure.resourcemanager.resources.models.ParametersLink;
import com.azure.resourcemanager.resources.models.TemplateLink;
import java.io.IOException;
import java.util.Map;

public final class DeploymentWhatIfProperties
extends DeploymentProperties {
    private DeploymentWhatIfSettings whatIfSettings;

    public DeploymentWhatIfSettings whatIfSettings() {
        return this.whatIfSettings;
    }

    public DeploymentWhatIfProperties withWhatIfSettings(DeploymentWhatIfSettings whatIfSettings) {
        this.whatIfSettings = whatIfSettings;
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withTemplate(Object template) {
        super.withTemplate(template);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withTemplateLink(TemplateLink templateLink) {
        super.withTemplateLink(templateLink);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withParameters(Map<String, DeploymentParameter> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withParametersLink(ParametersLink parametersLink) {
        super.withParametersLink(parametersLink);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withMode(DeploymentMode mode) {
        super.withMode(mode);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withDebugSetting(DebugSetting debugSetting) {
        super.withDebugSetting(debugSetting);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withOnErrorDeployment(OnErrorDeployment onErrorDeployment) {
        super.withOnErrorDeployment(onErrorDeployment);
        return this;
    }

    @Override
    public DeploymentWhatIfProperties withExpressionEvaluationOptions(ExpressionEvaluationOptions expressionEvaluationOptions) {
        super.withExpressionEvaluationOptions(expressionEvaluationOptions);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.whatIfSettings() != null) {
            this.whatIfSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode() == null ? null : this.mode().toString());
        jsonWriter.writeUntypedField("template", this.template());
        jsonWriter.writeJsonField("templateLink", (JsonSerializable)this.templateLink());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("parametersLink", (JsonSerializable)this.parametersLink());
        jsonWriter.writeJsonField("debugSetting", (JsonSerializable)this.debugSetting());
        jsonWriter.writeJsonField("onErrorDeployment", (JsonSerializable)this.onErrorDeployment());
        jsonWriter.writeJsonField("expressionEvaluationOptions", (JsonSerializable)this.expressionEvaluationOptions());
        jsonWriter.writeJsonField("whatIfSettings", (JsonSerializable)this.whatIfSettings);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentWhatIfProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentWhatIfProperties)jsonReader.readObject(reader -> {
            DeploymentWhatIfProperties deserializedDeploymentWhatIfProperties = new DeploymentWhatIfProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withMode(DeploymentMode.fromString(reader.getString()));
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withTemplate(reader.readUntyped());
                    continue;
                }
                if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withTemplateLink(TemplateLink.fromJson(reader));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> DeploymentParameter.fromJson(reader1));
                    deserializedDeploymentWhatIfProperties.withParameters(parameters);
                    continue;
                }
                if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withParametersLink(ParametersLink.fromJson(reader));
                    continue;
                }
                if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withDebugSetting(DebugSetting.fromJson(reader));
                    continue;
                }
                if ("onErrorDeployment".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withOnErrorDeployment(OnErrorDeployment.fromJson(reader));
                    continue;
                }
                if ("expressionEvaluationOptions".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withExpressionEvaluationOptions(ExpressionEvaluationOptions.fromJson(reader));
                    continue;
                }
                if ("whatIfSettings".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.whatIfSettings = DeploymentWhatIfSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentWhatIfProperties;
        });
    }
}

