/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.servicebus.fluent.TopicsClient;
import com.azure.resourcemanager.servicebus.fluent.models.AccessKeysInner;
import com.azure.resourcemanager.servicebus.fluent.models.SBAuthorizationRuleInner;
import com.azure.resourcemanager.servicebus.fluent.models.SBTopicInner;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.resourcemanager.servicebus.models.AccessRights;
import com.azure.resourcemanager.servicebus.models.RegenerateAccessKeyParameters;
import com.azure.resourcemanager.servicebus.models.SBAuthorizationRuleListResult;
import com.azure.resourcemanager.servicebus.models.SBTopicListResult;
import java.util.List;
import reactor.core.publisher.Mono;

public final class TopicsClientImpl
implements TopicsClient {
    private final ClientLogger logger = new ClientLogger(TopicsClientImpl.class);
    private final TopicsService service;
    private final ServiceBusManagementClientImpl client;

    TopicsClientImpl(ServiceBusManagementClientImpl client) {
        this.service = (TopicsService)RestProxy.create(TopicsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBAuthorizationRuleInner>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAuthorizationRules(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBAuthorizationRuleListResult)res.getValue()).value(), ((SBAuthorizationRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBAuthorizationRuleInner>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAuthorizationRules(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBAuthorizationRuleListResult)res.getValue()).value(), ((SBAuthorizationRuleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SBAuthorizationRuleInner> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String topicName) {
        return new PagedFlux(() -> this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName), nextLink -> this.listAuthorizationRulesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SBAuthorizationRuleInner> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return new PagedFlux(() -> this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName, context), nextLink -> this.listAuthorizationRulesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SBAuthorizationRuleInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String topicName) {
        return new PagedIterable(this.listAuthorizationRulesAsync(resourceGroupName, namespaceName, topicName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SBAuthorizationRuleInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return new PagedIterable(this.listAuthorizationRulesAsync(resourceGroupName, namespaceName, topicName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SBAuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        SBAuthorizationRuleInner parameters = new SBAuthorizationRuleInner();
        parameters.withRights(rights);
        return FluxUtil.withContext(context -> this.service.createOrUpdateAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SBAuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        SBAuthorizationRuleInner parameters = new SBAuthorizationRuleInner();
        parameters.withRights(rights);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SBAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights) {
        return this.createOrUpdateAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SBAuthorizationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SBAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        List<AccessRights> rights = null;
        return this.createOrUpdateAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SBAuthorizationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SBAuthorizationRuleInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        List<AccessRights> rights = null;
        return (SBAuthorizationRuleInner)((Object)this.createOrUpdateAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SBAuthorizationRuleInner> createOrUpdateAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights, Context context) {
        return (Response)this.createOrUpdateAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SBAuthorizationRuleInner>> getAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SBAuthorizationRuleInner>> getAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SBAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.getAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SBAuthorizationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SBAuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (SBAuthorizationRuleInner)((Object)this.getAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SBAuthorizationRuleInner> getAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.getAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAuthorizationRuleWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAuthorizationRule(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.deleteAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        this.deleteAuthorizationRuleAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAuthorizationRuleWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.deleteAuthorizationRuleWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessKeysInner>> listKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AccessKeysInner>> listKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.listKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AccessKeysInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessKeysInner listKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (AccessKeysInner)this.listKeysAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessKeysInner> listKeysWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Context context) {
        return (Response)this.listKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessKeysInner>> regenerateKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, RegenerateAccessKeyParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AccessKeysInner>> regenerateKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, RegenerateAccessKeyParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (authorizationRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateKeys(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, RegenerateAccessKeyParameters parameters) {
        return this.regenerateKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AccessKeysInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, RegenerateAccessKeyParameters parameters) {
        return (AccessKeysInner)this.regenerateKeysAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessKeysInner> regenerateKeysWithResponse(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, RegenerateAccessKeyParameters parameters, Context context) {
        return (Response)this.regenerateKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBTopicInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName, Integer skip, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespace(this.client.getEndpoint(), resourceGroupName, namespaceName, this.client.getApiVersion(), this.client.getSubscriptionId(), skip, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBTopicListResult)res.getValue()).value(), ((SBTopicListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBTopicInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName, Integer skip, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNamespace(this.client.getEndpoint(), resourceGroupName, namespaceName, this.client.getApiVersion(), this.client.getSubscriptionId(), skip, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBTopicListResult)res.getValue()).value(), ((SBTopicListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SBTopicInner> listByNamespaceAsync(String resourceGroupName, String namespaceName, Integer skip, Integer top) {
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, skip, top), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SBTopicInner> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        Integer skip = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, skip, top), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SBTopicInner> listByNamespaceAsync(String resourceGroupName, String namespaceName, Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, skip, top, context), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SBTopicInner> listByNamespace(String resourceGroupName, String namespaceName) {
        Integer skip = null;
        Integer top = null;
        return new PagedIterable(this.listByNamespaceAsync(resourceGroupName, namespaceName, skip, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SBTopicInner> listByNamespace(String resourceGroupName, String namespaceName, Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listByNamespaceAsync(resourceGroupName, namespaceName, skip, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SBTopicInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, SBTopicInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SBTopicInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, SBTopicInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SBTopicInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, SBTopicInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SBTopicInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SBTopicInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, SBTopicInner parameters) {
        return (SBTopicInner)((Object)this.createOrUpdateAsync(resourceGroupName, namespaceName, topicName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SBTopicInner> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String topicName, SBTopicInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicName) {
        this.deleteAsync(resourceGroupName, namespaceName, topicName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SBTopicInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SBTopicInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SBTopicInner> getAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, topicName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SBTopicInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SBTopicInner get(String resourceGroupName, String namespaceName, String topicName) {
        return (SBTopicInner)((Object)this.getAsync(resourceGroupName, namespaceName, topicName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SBTopicInner> getWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBAuthorizationRuleInner>> listAuthorizationRulesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAuthorizationRulesNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBAuthorizationRuleListResult)res.getValue()).value(), ((SBAuthorizationRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBAuthorizationRuleInner>> listAuthorizationRulesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAuthorizationRulesNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBAuthorizationRuleListResult)res.getValue()).value(), ((SBAuthorizationRuleListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBTopicInner>> listByNamespaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBTopicListResult)res.getValue()).value(), ((SBTopicListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SBTopicInner>> listByNamespaceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SBTopicListResult)res.getValue()).value(), ((SBTopicListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface TopicsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBAuthorizationRuleListResult>> listAuthorizationRules(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBAuthorizationRuleInner>> createOrUpdateAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") SBAuthorizationRuleInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBAuthorizationRuleInner>> getAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAuthorizationRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/ListKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AccessKeysInner>> listKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/regenerateKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AccessKeysInner>> regenerateKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="authorizationRuleName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") RegenerateAccessKeyParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBTopicListResult>> listByNamespace(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="$skip") Integer var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBTopicInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") SBTopicInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBTopicInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBAuthorizationRuleListResult>> listAuthorizationRulesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SBTopicListResult>> listByNamespaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

