/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ServiceTierAdvisorInner;
import com.azure.resourcemanager.sql.implementation.ServiceLevelObjectiveUsageMetricImpl;
import com.azure.resourcemanager.sql.models.ServiceLevelObjectiveUsageMetric;
import com.azure.resourcemanager.sql.models.ServiceTierAdvisor;
import com.azure.resourcemanager.sql.models.SloUsageMetric;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Mono;

class ServiceTierAdvisorImpl
extends RefreshableWrapperImpl<ServiceTierAdvisorInner, ServiceTierAdvisor>
implements ServiceTierAdvisor {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;
    private List<ServiceLevelObjectiveUsageMetric> serviceLevelObjectiveUsageMetrics;

    protected ServiceTierAdvisorImpl(String resourceGroupName, String sqlServerName, ServiceTierAdvisorInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString((String)((ServiceTierAdvisorInner)((Object)this.innerModel())).id());
    }

    public String name() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public OffsetDateTime observationPeriodStart() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).observationPeriodStart();
    }

    @Override
    public OffsetDateTime observationPeriodEnd() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).observationPeriodEnd();
    }

    @Override
    public double activeTimeRatio() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).activeTimeRatio();
    }

    @Override
    public double minDtu() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).minDtu();
    }

    @Override
    public double avgDtu() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).avgDtu();
    }

    @Override
    public double maxDtu() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).maxDtu();
    }

    @Override
    public double maxSizeInGB() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).maxSizeInGB();
    }

    @Override
    public List<ServiceLevelObjectiveUsageMetric> serviceLevelObjectiveUsageMetric() {
        if (this.serviceLevelObjectiveUsageMetrics == null) {
            this.serviceLevelObjectiveUsageMetrics = new ArrayList<ServiceLevelObjectiveUsageMetric>();
            for (SloUsageMetric sloUsageMetricInner : ((ServiceTierAdvisorInner)((Object)this.innerModel())).serviceLevelObjectiveUsageMetrics()) {
                this.serviceLevelObjectiveUsageMetrics.add(new ServiceLevelObjectiveUsageMetricImpl(sloUsageMetricInner));
            }
        }
        return this.serviceLevelObjectiveUsageMetrics;
    }

    @Override
    public String currentServiceLevelObjective() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).currentServiceLevelObjective();
    }

    @Override
    public UUID currentServiceLevelObjectiveId() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).currentServiceLevelObjectiveId();
    }

    @Override
    public String usageBasedRecommendationServiceLevelObjective() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).usageBasedRecommendationServiceLevelObjective();
    }

    @Override
    public UUID usageBasedRecommendationServiceLevelObjectiveId() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).currentServiceLevelObjectiveId();
    }

    @Override
    public String databaseSizeBasedRecommendationServiceLevelObjective() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).databaseSizeBasedRecommendationServiceLevelObjective();
    }

    @Override
    public UUID databaseSizeBasedRecommendationServiceLevelObjectiveId() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).databaseSizeBasedRecommendationServiceLevelObjectiveId();
    }

    @Override
    public String disasterPlanBasedRecommendationServiceLevelObjective() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).disasterPlanBasedRecommendationServiceLevelObjective();
    }

    @Override
    public UUID disasterPlanBasedRecommendationServiceLevelObjectiveId() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).disasterPlanBasedRecommendationServiceLevelObjectiveId();
    }

    @Override
    public String overallRecommendationServiceLevelObjective() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).overallRecommendationServiceLevelObjective();
    }

    @Override
    public UUID overallRecommendationServiceLevelObjectiveId() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).overallRecommendationServiceLevelObjectiveId();
    }

    @Override
    public double confidence() {
        return ((ServiceTierAdvisorInner)((Object)this.innerModel())).confidence();
    }

    protected Mono<ServiceTierAdvisorInner> getInnerAsync() {
        this.serviceLevelObjectiveUsageMetrics = null;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServiceTierAdvisors().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }
}

