/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.FirewallRuleInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SqlFirewallRule;
import com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlFirewallRuleImpl
extends ExternalChildResourceImpl<SqlFirewallRule, FirewallRuleInner, SqlServerImpl, SqlServer>
implements SqlFirewallRule,
SqlFirewallRule.SqlFirewallRuleDefinition<SqlServerImpl>,
SqlFirewallRule.Update,
SqlFirewallRuleOperations.SqlFirewallRuleOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlFirewallRuleImpl(String name, SqlServerImpl parent, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlFirewallRuleImpl(String resourceGroupName, String sqlServerName, String name, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlFirewallRuleImpl(String name, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    protected Mono<FirewallRuleInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public SqlFirewallRuleImpl update() {
        super.prepareUpdate();
        return this;
    }

    public String id() {
        return ((FirewallRuleInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String startIpAddress() {
        return ((FirewallRuleInner)((Object)this.innerModel())).startIpAddress();
    }

    @Override
    public String endIpAddress() {
        return ((FirewallRuleInner)((Object)this.innerModel())).endIpAddress();
    }

    @Override
    public String kind() {
        return ((FirewallRuleInner)((Object)this.innerModel())).kind();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((FirewallRuleInner)((Object)this.innerModel())).location());
    }

    @Override
    public void delete() {
        this.deleteResourceAsync().block();
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    public Mono<SqlFirewallRule> createResourceAsync() {
        SqlFirewallRuleImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (FirewallRuleInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    public Mono<SqlFirewallRule> updateResourceAsync() {
        SqlFirewallRuleImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (FirewallRuleInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public SqlFirewallRuleImpl withStartIpAddress(String startIpAddress) {
        ((FirewallRuleInner)((Object)this.innerModel())).withStartIpAddress(startIpAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withEndIpAddress(String endIpAddress) {
        ((FirewallRuleInner)((Object)this.innerModel())).withEndIpAddress(endIpAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIpAddressRange(String startIpAddress, String endIpAddress) {
        ((FirewallRuleInner)((Object)this.innerModel())).withStartIpAddress(startIpAddress);
        ((FirewallRuleInner)((Object)this.innerModel())).withEndIpAddress(endIpAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIpAddress(String ipAddress) {
        ((FirewallRuleInner)((Object)this.innerModel())).withStartIpAddress(ipAddress);
        ((FirewallRuleInner)((Object)this.innerModel())).withEndIpAddress(ipAddress);
        return this;
    }

    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }
}

