/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={SqlManagementClientImpl.class})
public final class SqlManagementClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public SqlManagementClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public SqlManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SqlManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public SqlManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public SqlManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public SqlManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public SqlManagementClientImpl buildClient() {
        if (this.endpoint == null) {
            this.endpoint = "https://management.azure.com";
        }
        if (this.environment == null) {
            this.environment = AzureEnvironment.AZURE;
        }
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        }
        if (this.defaultPollInterval == null) {
            this.defaultPollInterval = Duration.ofSeconds(30L);
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        }
        SqlManagementClientImpl client = new SqlManagementClientImpl(this.pipeline, this.serializerAdapter, this.defaultPollInterval, this.environment, this.subscriptionId, this.endpoint);
        return client;
    }
}

