/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceProperties;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ManagedInstanceUpdate {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private ManagedInstanceProperties innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public ManagedInstanceUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ManagedInstanceProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedInstanceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.innerProperties() == null ? null : this.innerProperties().managedInstanceCreateMode();
    }

    public ManagedInstanceUpdate withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withManagedInstanceCreateMode(managedInstanceCreateMode);
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ManagedInstanceUpdate withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ManagedInstanceUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public ManagedInstanceUpdate withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public ManagedInstanceLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public ManagedInstanceUpdate withLicenseType(ManagedInstanceLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public Integer vCores() {
        return this.innerProperties() == null ? null : this.innerProperties().vCores();
    }

    public ManagedInstanceUpdate withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    public Integer storageSizeInGB() {
        return this.innerProperties() == null ? null : this.innerProperties().storageSizeInGB();
    }

    public ManagedInstanceUpdate withStorageSizeInGB(Integer storageSizeInGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withStorageSizeInGB(storageSizeInGB);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public ManagedInstanceUpdate withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public String dnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZone();
    }

    public String dnsZonePartner() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZonePartner();
    }

    public ManagedInstanceUpdate withDnsZonePartner(String dnsZonePartner) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withDnsZonePartner(dnsZonePartner);
        return this;
    }

    public Boolean publicDataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().publicDataEndpointEnabled();
    }

    public ManagedInstanceUpdate withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withPublicDataEndpointEnabled(publicDataEndpointEnabled);
        return this;
    }

    public String sourceManagedInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceManagedInstanceId();
    }

    public ManagedInstanceUpdate withSourceManagedInstanceId(String sourceManagedInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSourceManagedInstanceId(sourceManagedInstanceId);
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    public ManagedInstanceUpdate withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    public ManagedInstanceProxyOverride proxyOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().proxyOverride();
    }

    public ManagedInstanceUpdate withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withProxyOverride(proxyOverride);
        return this;
    }

    public String timezoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().timezoneId();
    }

    public ManagedInstanceUpdate withTimezoneId(String timezoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withTimezoneId(timezoneId);
        return this;
    }

    public String instancePoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().instancePoolId();
    }

    public ManagedInstanceUpdate withInstancePoolId(String instancePoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withInstancePoolId(instancePoolId);
        return this;
    }

    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ManagedInstanceUpdate withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

