/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.models.ServerInner;
import com.azure.resourcemanager.sql.models.IdentityType;
import com.azure.resourcemanager.sql.models.RecommendedElasticPool;
import com.azure.resourcemanager.sql.models.ServerMetric;
import com.azure.resourcemanager.sql.models.ServiceObjective;
import com.azure.resourcemanager.sql.models.SqlActiveDirectoryAdministrator;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.azure.resourcemanager.sql.models.SqlElasticPool;
import com.azure.resourcemanager.sql.models.SqlElasticPoolOperations;
import com.azure.resourcemanager.sql.models.SqlEncryptionProtectorOperations;
import com.azure.resourcemanager.sql.models.SqlFailoverGroupOperations;
import com.azure.resourcemanager.sql.models.SqlFirewallRule;
import com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.azure.resourcemanager.sql.models.SqlRestorableDroppedDatabase;
import com.azure.resourcemanager.sql.models.SqlServerAutomaticTuning;
import com.azure.resourcemanager.sql.models.SqlServerDnsAliasOperations;
import com.azure.resourcemanager.sql.models.SqlServerKeyOperations;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRule;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import java.util.List;
import java.util.Map;

public interface SqlServer
extends GroupableResource<SqlServerManager, ServerInner>,
Refreshable<SqlServer>,
Updatable<Update> {
    public String fullyQualifiedDomainName();

    public String administratorLogin();

    public String version();

    public String kind();

    public String state();

    public boolean isManagedServiceIdentityEnabled();

    public String systemAssignedManagedServiceIdentityTenantId();

    public String systemAssignedManagedServiceIdentityPrincipalId();

    public IdentityType managedServiceIdentityType();

    public List<ServerMetric> listUsageMetrics();

    public List<ServiceObjective> listServiceObjectives();

    public ServiceObjective getServiceObjective(String var1);

    public Map<String, RecommendedElasticPool> listRecommendedElasticPools();

    public List<SqlRestorableDroppedDatabase> listRestorableDroppedDatabases();

    public PagedFlux<SqlRestorableDroppedDatabase> listRestorableDroppedDatabasesAsync();

    public SqlFirewallRule enableAccessFromAzureServices();

    public void removeAccessFromAzureServices();

    public SqlActiveDirectoryAdministrator setActiveDirectoryAdministrator(String var1, String var2);

    public SqlActiveDirectoryAdministrator getActiveDirectoryAdministrator();

    public void removeActiveDirectoryAdministrator();

    public SqlServerAutomaticTuning getServerAutomaticTuning();

    public SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition firewallRules();

    public SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition virtualNetworkRules();

    public SqlElasticPoolOperations.SqlElasticPoolActionsDefinition elasticPools();

    public SqlDatabaseOperations.SqlDatabaseActionsDefinition databases();

    public SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition dnsAliases();

    public SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition failoverGroups();

    public SqlServerKeyOperations.SqlServerKeyActionsDefinition serverKeys();

    public SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition encryptionProtectors();

    public SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition serverSecurityAlertPolicies();

    public static interface UpdateStages {

        public static interface WithFirewallRule {
            public SqlFirewallRule.DefinitionStages.Blank<? extends Update> defineFirewallRule(String var1);

            public Update withoutFirewallRule(String var1);
        }

        public static interface WithDatabase {
            public SqlDatabase.DefinitionStages.Blank<? extends Update> defineDatabase(String var1);

            public Update withoutDatabase(String var1);
        }

        public static interface WithElasticPool {
            public SqlElasticPool.DefinitionStages.Blank<? extends Update> defineElasticPool(String var1);

            public Update withoutElasticPool(String var1);
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public Update withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithAdministratorPassword {
            public Update withAdministratorPassword(String var1);
        }
    }

    public static interface Update
    extends Appliable<SqlServer>,
    UpdateStages.WithAdministratorPassword,
    UpdateStages.WithElasticPool,
    UpdateStages.WithDatabase,
    UpdateStages.WithFirewallRule,
    UpdateStages.WithSystemAssignedManagedServiceIdentity,
    Resource.UpdateWithTags<Update> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<SqlServer>,
        WithActiveDirectoryAdministrator,
        WithSystemAssignedManagedServiceIdentity,
        WithElasticPool,
        WithDatabase,
        WithFirewallRule,
        WithVirtualNetworkRule,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithVirtualNetworkRule {
            public SqlVirtualNetworkRule.DefinitionStages.Blank<? extends WithCreate> defineVirtualNetworkRule(String var1);
        }

        public static interface WithFirewallRule {
            public WithCreate withoutAccessFromAzureServices();

            public SqlFirewallRule.DefinitionStages.Blank<? extends WithCreate> defineFirewallRule(String var1);
        }

        public static interface WithDatabase {
            public SqlDatabase.DefinitionStages.Blank<? extends WithCreate> defineDatabase(String var1);
        }

        public static interface WithElasticPool {
            public SqlElasticPool.DefinitionStages.Blank<? extends WithCreate> defineElasticPool(String var1);
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public WithCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithActiveDirectoryAdministrator {
            public WithCreate withActiveDirectoryAdministrator(String var1, String var2);
        }

        public static interface WithAdministratorPassword {
            public WithCreate withAdministratorPassword(String var1);
        }

        public static interface WithAdministratorLogin {
            public WithAdministratorPassword withAdministratorLogin(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithAdministratorLogin> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithAdministratorLogin,
    DefinitionStages.WithAdministratorPassword,
    DefinitionStages.WithElasticPool,
    DefinitionStages.WithDatabase,
    DefinitionStages.WithFirewallRule,
    DefinitionStages.WithCreate {
    }
}

