/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.LongTermRetentionBackupsClient;
import com.azure.resourcemanager.sql.fluent.models.LongTermRetentionBackupInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.LongTermRetentionBackupListResult;
import com.azure.resourcemanager.sql.models.LongTermRetentionDatabaseState;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class LongTermRetentionBackupsClientImpl
implements LongTermRetentionBackupsClient {
    private final LongTermRetentionBackupsService service;
    private final SqlManagementClientImpl client;

    LongTermRetentionBackupsClientImpl(SqlManagementClientImpl client) {
        this.service = (LongTermRetentionBackupsService)RestProxy.create(LongTermRetentionBackupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LongTermRetentionBackupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LongTermRetentionBackupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupInner> getByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LongTermRetentionBackupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LongTermRetentionBackupInner getByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return (LongTermRetentionBackupInner)((Object)this.getByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LongTermRetentionBackupInner> getByResourceGroupWithResponse(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroupWithResponseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.deleteByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroupWithResponseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.deleteByResourceGroup(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteByResourceGroupWithResponseAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteByResourceGroupWithResponseAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this.beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return this.beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this.beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return this.beginDeleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        this.deleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteByResourceGroup(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        this.deleteByResourceGroupAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseSinglePageAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupDatabase(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseSinglePageAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupDatabase(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux(() -> this.listByResourceGroupDatabaseSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByResourceGroupDatabaseNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux(() -> this.listByResourceGroupDatabaseSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByResourceGroupDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupDatabaseSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context), nextLink -> this.listByResourceGroupDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupDatabase(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable(this.listByResourceGroupDatabaseAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupDatabase(String resourceGroupName, String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedIterable(this.listByResourceGroupDatabaseAsync(resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationSinglePageAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupLocation(this.client.getEndpoint(), resourceGroupName, locationName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationSinglePageAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupLocation(this.client.getEndpoint(), resourceGroupName, locationName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux(() -> this.listByResourceGroupLocationSinglePageAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByResourceGroupLocationNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(String resourceGroupName, String locationName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux(() -> this.listByResourceGroupLocationSinglePageAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByResourceGroupLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupLocationSinglePageAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState, context), nextLink -> this.listByResourceGroupLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupLocation(String resourceGroupName, String locationName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable(this.listByResourceGroupLocationAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupLocation(String resourceGroupName, String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedIterable(this.listByResourceGroupLocationAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerSinglePageAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupServer(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerSinglePageAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupServer(this.client.getEndpoint(), resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux(() -> this.listByResourceGroupServerSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByResourceGroupServerNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(String resourceGroupName, String locationName, String longTermRetentionServerName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux(() -> this.listByResourceGroupServerSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByResourceGroupServerNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(String resourceGroupName, String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupServerSinglePageAsync(resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context), nextLink -> this.listByResourceGroupServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupServer(String resourceGroupName, String locationName, String longTermRetentionServerName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable(this.listByResourceGroupServerAsync(resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupServer(String resourceGroupName, String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedIterable(this.listByResourceGroupServerAsync(resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LongTermRetentionBackupInner>> getWithResponseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LongTermRetentionBackupInner>> getWithResponseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupInner> getAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this.getWithResponseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LongTermRetentionBackupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LongTermRetentionBackupInner get(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return (LongTermRetentionBackupInner)((Object)this.getAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LongTermRetentionBackupInner> getWithResponse(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return (Response)this.getWithResponseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this.beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return this.beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        return this.beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        return this.beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName) {
        this.deleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, String backupName, Context context) {
        this.deleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseSinglePageAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseSinglePageAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByDatabase(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable(this.listByDatabaseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByDatabase(String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedIterable(this.listByDatabaseAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationSinglePageAsync(String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocation(this.client.getEndpoint(), locationName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationSinglePageAsync(String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocation(this.client.getEndpoint(), locationName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedFlux(() -> this.listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState, context), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByLocation(String locationName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable(this.listByLocationAsync(locationName, onlyLatestPerDatabase, databaseState));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByLocation(String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedIterable(this.listByLocationAsync(locationName, onlyLatestPerDatabase, databaseState, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerSinglePageAsync(String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServer(this.client.getEndpoint(), locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerSinglePageAsync(String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServer(this.client.getEndpoint(), locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, this.client.getSubscriptionId(), "2017-03-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByServerAsync(String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByServerAsync(String locationName, String longTermRetentionServerName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux(() -> this.listByServerSinglePageAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByServerAsync(String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByServer(String locationName, String longTermRetentionServerName) {
        Boolean onlyLatestPerDatabase = null;
        LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable(this.listByServerAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByServer(String locationName, String longTermRetentionServerName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState, Context context) {
        return new PagedIterable(this.listByServerAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupServerNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupServerNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServerNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServerNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LongTermRetentionBackupListResult)res.getValue()).value(), ((LongTermRetentionBackupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientL")
    private static interface LongTermRetentionBackupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="longTermRetentionServerName") String var4, @PathParam(value="longTermRetentionDatabaseName") String var5, @PathParam(value="backupName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="longTermRetentionServerName") String var4, @PathParam(value="longTermRetentionDatabaseName") String var5, @PathParam(value="backupName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="longTermRetentionServerName") String var4, @PathParam(value="longTermRetentionDatabaseName") String var5, @QueryParam(value="onlyLatestPerDatabase") Boolean var6, @QueryParam(value="databaseState") LongTermRetentionDatabaseState var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupLocation(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @QueryParam(value="onlyLatestPerDatabase") Boolean var4, @QueryParam(value="databaseState") LongTermRetentionDatabaseState var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupServer(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="locationName") String var3, @PathParam(value="longTermRetentionServerName") String var4, @QueryParam(value="onlyLatestPerDatabase") Boolean var5, @QueryParam(value="databaseState") LongTermRetentionDatabaseState var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="longTermRetentionServerName") String var3, @PathParam(value="longTermRetentionDatabaseName") String var4, @PathParam(value="backupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="longTermRetentionServerName") String var3, @PathParam(value="longTermRetentionDatabaseName") String var4, @PathParam(value="backupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="longTermRetentionServerName") String var3, @PathParam(value="longTermRetentionDatabaseName") String var4, @QueryParam(value="onlyLatestPerDatabase") Boolean var5, @QueryParam(value="databaseState") LongTermRetentionDatabaseState var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByLocation(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @QueryParam(value="onlyLatestPerDatabase") Boolean var3, @QueryParam(value="databaseState") LongTermRetentionDatabaseState var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByServer(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="longTermRetentionServerName") String var3, @QueryParam(value="onlyLatestPerDatabase") Boolean var4, @QueryParam(value="databaseState") LongTermRetentionDatabaseState var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupServerNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LongTermRetentionBackupListResult>> listByServerNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

