/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.resourcemanager.sql.fluent.models.ElasticPoolUpdateProperties;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ElasticPoolUpdate {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private ElasticPoolUpdateProperties innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public ElasticPoolUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ElasticPoolUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ElasticPoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public ElasticPoolUpdate withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().perDatabaseSettings();
    }

    public ElasticPoolUpdate withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withPerDatabaseSettings(perDatabaseSettings);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public ElasticPoolUpdate withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public ElasticPoolUpdate withLicenseType(ElasticPoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

