/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlDatabaseOperationsImpl
implements SqlDatabaseOperations,
SqlDatabaseOperations.SqlDatabaseActionsDefinition {
    private SqlServerManager manager;
    private SqlServerImpl sqlServer;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases;

    SqlDatabaseOperationsImpl(SqlServerImpl parent, SqlServerManager manager) {
        Objects.requireNonNull(manager);
        this.sqlServer = parent;
        this.manager = manager;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.sqlServer.taskGroup(), manager, "SqlDatabase");
    }

    SqlDatabaseOperationsImpl(SqlServerManager manager) {
        Objects.requireNonNull(manager);
        this.manager = manager;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(null, manager, "SqlDatabase");
    }

    @Override
    public SqlDatabase getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        DatabaseInner inner = ((SqlManagementClient)this.manager.serviceClient()).getDatabases().get(resourceGroupName, sqlServerName, name);
        return inner != null ? new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), inner, this.manager) : null;
    }

    @Override
    public Mono<SqlDatabase> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.manager.serviceClient()).getDatabases().getAsync(resourceGroupName, sqlServerName, name).map(inner -> new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), (DatabaseInner)((Object)inner), this.manager));
    }

    @Override
    public SqlDatabase getBySqlServer(SqlServer sqlServer, String name) {
        if (sqlServer == null) {
            return null;
        }
        DatabaseInner inner = ((SqlManagementClient)this.manager.serviceClient()).getDatabases().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return inner != null ? new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.manager) : null;
    }

    @Override
    public Mono<SqlDatabase> getBySqlServerAsync(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getDatabases().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map(inner -> new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, (DatabaseInner)((Object)inner), this.manager));
    }

    @Override
    public SqlDatabase get(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public Mono<SqlDatabase> getAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public SqlDatabase getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Mono<SqlDatabase> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClient)this.manager.serviceClient()).getDatabases().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Mono<Void> deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.manager.serviceClient()).getDatabases().deleteAsync(resourceGroupName, sqlServerName, name);
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        this.deleteBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.deleteBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void delete(String name) {
        if (this.sqlServer != null) {
            this.deleteBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
        }
    }

    @Override
    public Mono<Void> deleteAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.deleteBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public List<SqlDatabase> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlDatabaseImpl> databasesSet = new ArrayList<SqlDatabaseImpl>();
        for (DatabaseInner inner : ((SqlManagementClient)this.manager.serviceClient()).getDatabases().listByServer(resourceGroupName, sqlServerName)) {
            databasesSet.add(new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), inner, this.manager));
        }
        return Collections.unmodifiableList(databasesSet);
    }

    @Override
    public PagedFlux<SqlDatabase> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        return PagedConverter.mapPage(((SqlManagementClient)this.manager.serviceClient()).getDatabases().listByServerAsync(resourceGroupName, sqlServerName), inner -> new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), (DatabaseInner)((Object)inner), this.manager));
    }

    @Override
    public List<SqlDatabase> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlDatabaseImpl> firewallRuleSet = new ArrayList<SqlDatabaseImpl>();
        if (sqlServer != null) {
            for (DatabaseInner inner : ((SqlManagementClient)this.manager.serviceClient()).getDatabases().listByServer(sqlServer.resourceGroupName(), sqlServer.name())) {
                firewallRuleSet.add(new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.manager));
            }
        }
        return Collections.unmodifiableList(firewallRuleSet);
    }

    @Override
    public PagedFlux<SqlDatabase> listBySqlServerAsync(SqlServer sqlServer) {
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getDatabases().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()), inner -> new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, (DatabaseInner)((Object)inner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public List<SqlDatabase> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name());
    }

    @Override
    public PagedFlux<SqlDatabase> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name());
    }

    @Override
    public SqlDatabaseImpl define(String name) {
        SqlDatabaseImpl result = this.sqlDatabases.defineIndependentDatabase(name);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

