/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.sql.fluent.models.SyncGroupInner;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlSyncFullSchemaProperty;
import com.azure.resourcemanager.sql.models.SqlSyncGroupLogProperty;
import com.azure.resourcemanager.sql.models.SqlSyncMemberOperations;
import com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.azure.resourcemanager.sql.models.SyncGroupState;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public interface SqlSyncGroup
extends ExternalChildResource<SqlSyncGroup, SqlDatabase>,
HasInnerModel<SyncGroupInner>,
HasResourceGroup,
Refreshable<SqlSyncGroup>,
Updatable<Update> {
    public String sqlServerName();

    public String sqlDatabaseName();

    public String parentId();

    public int interval();

    public OffsetDateTime lastSyncTime();

    public SyncConflictResolutionPolicy conflictResolutionPolicy();

    public String syncDatabaseId();

    public String databaseUserName();

    public SyncGroupState syncState();

    public SyncGroupSchema schema();

    public void delete();

    public Mono<Void> deleteAsync();

    public void refreshHubSchema();

    public Mono<Void> refreshHubSchemaAsync();

    public PagedIterable<SqlSyncFullSchemaProperty> listHubSchemas();

    public PagedFlux<SqlSyncFullSchemaProperty> listHubSchemasAsync();

    public PagedIterable<SqlSyncGroupLogProperty> listLogs(String var1, String var2, String var3);

    public PagedFlux<SqlSyncGroupLogProperty> listLogsAsync(String var1, String var2, String var3);

    public void triggerSynchronization();

    public Mono<Void> triggerSynchronizationAsync();

    public void cancelSynchronization();

    public Mono<Void> cancelSynchronizationAsync();

    public SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMembers();

    public static interface UpdateStages {

        public static interface WithInterval {
            public Update withInterval(int var1);
        }

        public static interface WithConflictResolutionPolicy {
            public Update withConflictResolutionPolicyHubWins();

            public Update withConflictResolutionPolicyMemberWins();
        }

        public static interface WithSchema {
            public Update withSchema(SyncGroupSchema var1);
        }

        public static interface WithDatabasePassword {
            public Update withDatabasePassword(String var1);
        }

        public static interface WithDatabaseUserName {
            public Update withDatabaseUserName(String var1);
        }

        public static interface WithSyncDatabaseId {
            public Update withSyncDatabaseId(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithSyncDatabaseId,
    UpdateStages.WithDatabaseUserName,
    UpdateStages.WithDatabasePassword,
    UpdateStages.WithConflictResolutionPolicy,
    UpdateStages.WithInterval,
    UpdateStages.WithSchema,
    Appliable<SqlSyncGroup> {
    }
}

