// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.models.LedgerDigestUploadsInner;
import com.azure.resourcemanager.sql.models.LedgerDigestUploadsName;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in LedgerDigestUploadsOperationsClient. */
public interface LedgerDigestUploadsOperationsClient {
    /**
     * Gets all ledger digest upload settings on a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all ledger digest upload settings on a database as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<LedgerDigestUploadsInner> listByDatabaseAsync(
        String resourceGroupName, String serverName, String databaseName);

    /**
     * Gets all ledger digest upload settings on a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all ledger digest upload settings on a database as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LedgerDigestUploadsInner> listByDatabase(
        String resourceGroupName, String serverName, String databaseName);

    /**
     * Gets all ledger digest upload settings on a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all ledger digest upload settings on a database as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LedgerDigestUploadsInner> listByDatabase(
        String resourceGroupName, String serverName, String databaseName, Context context);

    /**
     * Gets the current ledger digest upload configuration for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current ledger digest upload configuration for a database along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<LedgerDigestUploadsInner>> getWithResponseAsync(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Gets the current ledger digest upload configuration for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current ledger digest upload configuration for a database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<LedgerDigestUploadsInner> getAsync(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Gets the current ledger digest upload configuration for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current ledger digest upload configuration for a database along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LedgerDigestUploadsInner> getWithResponse(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        Context context);

    /**
     * Gets the current ledger digest upload configuration for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current ledger digest upload configuration for a database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LedgerDigestUploadsInner get(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<LedgerDigestUploadsInner>, LedgerDigestUploadsInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<LedgerDigestUploadsInner>, LedgerDigestUploadsInner> beginCreateOrUpdate(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<LedgerDigestUploadsInner>, LedgerDigestUploadsInner> beginCreateOrUpdate(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters,
        Context context);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<LedgerDigestUploadsInner> createOrUpdateAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LedgerDigestUploadsInner createOrUpdate(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters);

    /**
     * Enables upload ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param parameters Azure SQL Database ledger digest upload settings.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LedgerDigestUploadsInner createOrUpdate(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        LedgerDigestUploadsInner parameters,
        Context context);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> disableWithResponseAsync(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<LedgerDigestUploadsInner>, LedgerDigestUploadsInner> beginDisableAsync(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<LedgerDigestUploadsInner>, LedgerDigestUploadsInner> beginDisable(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<LedgerDigestUploadsInner>, LedgerDigestUploadsInner> beginDisable(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        Context context);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<LedgerDigestUploadsInner> disableAsync(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LedgerDigestUploadsInner disable(
        String resourceGroupName, String serverName, String databaseName, LedgerDigestUploadsName ledgerDigestUploads);

    /**
     * Disables uploading ledger digests to an Azure Storage account or an Azure Confidential Ledger instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param ledgerDigestUploads The ledgerDigestUploads parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure SQL Database ledger digest upload settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LedgerDigestUploadsInner disable(
        String resourceGroupName,
        String serverName,
        String databaseName,
        LedgerDigestUploadsName ledgerDigestUploads,
        Context context);
}
