// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceAzureADOnlyAuthenticationInner;
import com.azure.resourcemanager.sql.models.AuthenticationName;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ManagedInstanceAzureADOnlyAuthenticationsClient.
 */
public interface ManagedInstanceAzureADOnlyAuthenticationsClient {
    /**
     * Gets a list of server Azure Active Directory only authentications.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of server Azure Active Directory only authentications as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedInstanceAzureADOnlyAuthenticationInner> listByInstanceAsync(
        String resourceGroupName, String managedInstanceName);

    /**
     * Gets a list of server Azure Active Directory only authentications.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of server Azure Active Directory only authentications as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedInstanceAzureADOnlyAuthenticationInner> listByInstance(
        String resourceGroupName, String managedInstanceName);

    /**
     * Gets a list of server Azure Active Directory only authentications.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of server Azure Active Directory only authentications as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedInstanceAzureADOnlyAuthenticationInner> listByInstance(
        String resourceGroupName, String managedInstanceName, Context context);

    /**
     * Gets a specific Azure Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Azure Active Directory only authentication property along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedInstanceAzureADOnlyAuthenticationInner>> getWithResponseAsync(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Gets a specific Azure Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Azure Active Directory only authentication property on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedInstanceAzureADOnlyAuthenticationInner> getAsync(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Gets a specific Azure Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Azure Active Directory only authentication property along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedInstanceAzureADOnlyAuthenticationInner> getWithResponse(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName, Context context);

    /**
     * Gets a specific Azure Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Azure Active Directory only authentication property.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedInstanceAzureADOnlyAuthenticationInner get(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure Active Directory only authentication along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        AuthenticationName authenticationName,
        ManagedInstanceAzureADOnlyAuthenticationInner parameters);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of azure Active Directory only authentication.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ManagedInstanceAzureADOnlyAuthenticationInner>, ManagedInstanceAzureADOnlyAuthenticationInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String managedInstanceName,
            AuthenticationName authenticationName,
            ManagedInstanceAzureADOnlyAuthenticationInner parameters);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure Active Directory only authentication.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedInstanceAzureADOnlyAuthenticationInner>, ManagedInstanceAzureADOnlyAuthenticationInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String managedInstanceName,
            AuthenticationName authenticationName,
            ManagedInstanceAzureADOnlyAuthenticationInner parameters);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure Active Directory only authentication.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedInstanceAzureADOnlyAuthenticationInner>, ManagedInstanceAzureADOnlyAuthenticationInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String managedInstanceName,
            AuthenticationName authenticationName,
            ManagedInstanceAzureADOnlyAuthenticationInner parameters,
            Context context);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure Active Directory only authentication on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedInstanceAzureADOnlyAuthenticationInner> createOrUpdateAsync(
        String resourceGroupName,
        String managedInstanceName,
        AuthenticationName authenticationName,
        ManagedInstanceAzureADOnlyAuthenticationInner parameters);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure Active Directory only authentication.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedInstanceAzureADOnlyAuthenticationInner createOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        AuthenticationName authenticationName,
        ManagedInstanceAzureADOnlyAuthenticationInner parameters);

    /**
     * Sets Server Active Directory only authentication property or updates an existing server Active Directory only
     * authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param parameters The required parameters for creating or updating an Active Directory only authentication
     *     property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure Active Directory only authentication.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedInstanceAzureADOnlyAuthenticationInner createOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        AuthenticationName authenticationName,
        ManagedInstanceAzureADOnlyAuthenticationInner parameters,
        Context context);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName, Context context);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName);

    /**
     * Deletes an existing server Active Directory only authentication property.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param authenticationName The name of server azure active directory only authentication.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(
        String resourceGroupName, String managedInstanceName, AuthenticationName authenticationName, Context context);
}
