// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.AdvisorStatus;
import com.azure.resourcemanager.sql.models.AutoExecuteStatus;
import com.azure.resourcemanager.sql.models.AutoExecuteStatusInheritedFrom;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Database, Server or Elastic Pool Advisor. */
@Fluent
public final class AdvisorInner extends ProxyResource {
    /*
     * Resource kind.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /*
     * Resource location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private AdvisorProperties innerProperties;

    /** Creates an instance of AdvisorInner class. */
    public AdvisorInner() {
    }

    /**
     * Get the kind property: Resource kind.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the location property: Resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private AdvisorProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the advisorStatus property: Gets the status of availability of this advisor to customers. Possible values are
     * 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'.
     *
     * @return the advisorStatus value.
     */
    public AdvisorStatus advisorStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().advisorStatus();
    }

    /**
     * Get the autoExecuteStatus property: Gets the auto-execute status (whether to let the system execute the
     * recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'.
     *
     * @return the autoExecuteStatus value.
     */
    public AutoExecuteStatus autoExecuteStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().autoExecuteStatus();
    }

    /**
     * Set the autoExecuteStatus property: Gets the auto-execute status (whether to let the system execute the
     * recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'.
     *
     * @param autoExecuteStatus the autoExecuteStatus value to set.
     * @return the AdvisorInner object itself.
     */
    public AdvisorInner withAutoExecuteStatus(AutoExecuteStatus autoExecuteStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdvisorProperties();
        }
        this.innerProperties().withAutoExecuteStatus(autoExecuteStatus);
        return this;
    }

    /**
     * Get the autoExecuteStatusInheritedFrom property: Gets the resource from which current value of auto-execute
     * status is inherited. Auto-execute status can be set on (and inherited from) different levels in the resource
     * hierarchy. Possible values are 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is
     * not explicitly set on any level).
     *
     * @return the autoExecuteStatusInheritedFrom value.
     */
    public AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom() {
        return this.innerProperties() == null ? null : this.innerProperties().autoExecuteStatusInheritedFrom();
    }

    /**
     * Get the recommendationsStatus property: Gets that status of recommendations for this advisor and reason for not
     * having any recommendations. Possible values include, but are not limited to, 'Ok' (Recommendations
     * available),LowActivity (not enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
     *
     * @return the recommendationsStatus value.
     */
    public String recommendationsStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationsStatus();
    }

    /**
     * Get the lastChecked property: Gets the time when the current resource was analyzed for recommendations by this
     * advisor.
     *
     * @return the lastChecked value.
     */
    public OffsetDateTime lastChecked() {
        return this.innerProperties() == null ? null : this.innerProperties().lastChecked();
    }

    /**
     * Get the recommendedActions property: Gets the recommended actions for this advisor.
     *
     * @return the recommendedActions value.
     */
    public List<RecommendedActionInner> recommendedActions() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendedActions();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
