// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of the export operation's result. */
@Immutable
public final class DatabaseVulnerabilityAssessmentScanExportProperties {
    /*
     * Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     */
    @JsonProperty(value = "exportedReportLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String exportedReportLocation;

    /** Creates an instance of DatabaseVulnerabilityAssessmentScanExportProperties class. */
    public DatabaseVulnerabilityAssessmentScanExportProperties() {
    }

    /**
     * Get the exportedReportLocation property: Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     *
     * @return the exportedReportLocation value.
     */
    public String exportedReportLocation() {
        return this.exportedReportLocation;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
