// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

/** A LongTermRetentionBackup operation result resource. */
@Immutable
public final class LongTermRetentionBackupOperationResultInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private LongTermRetentionOperationResultProperties innerProperties;

    /** Creates an instance of LongTermRetentionBackupOperationResultInner class. */
    public LongTermRetentionBackupOperationResultInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private LongTermRetentionOperationResultProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the requestId property: Request Id.
     *
     * @return the requestId value.
     */
    public UUID requestId() {
        return this.innerProperties() == null ? null : this.innerProperties().requestId();
    }

    /**
     * Get the operationType property: Operation type.
     *
     * @return the operationType value.
     */
    public String operationType() {
        return this.innerProperties() == null ? null : this.innerProperties().operationType();
    }

    /**
     * Get the fromBackupResourceId property: Source backup resource id.
     *
     * @return the fromBackupResourceId value.
     */
    public String fromBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().fromBackupResourceId();
    }

    /**
     * Get the toBackupResourceId property: Target backup resource id.
     *
     * @return the toBackupResourceId value.
     */
    public String toBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().toBackupResourceId();
    }

    /**
     * Get the targetBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     *
     * @return the targetBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy targetBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().targetBackupStorageRedundancy();
    }

    /**
     * Get the status property: Operation status.
     *
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the message property: Progress message.
     *
     * @return the message value.
     */
    public String message() {
        return this.innerProperties() == null ? null : this.innerProperties().message();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
