// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.models.QueryMetricInterval;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of a query execution statistics. */
@Fluent
public final class QueryStatisticsProperties {
    /*
     * Database name of the database in which this query was executed.
     */
    @JsonProperty(value = "databaseName", access = JsonProperty.Access.WRITE_ONLY)
    private String databaseName;

    /*
     * Unique query id (unique within one database).
     */
    @JsonProperty(value = "queryId", access = JsonProperty.Access.WRITE_ONLY)
    private String queryId;

    /*
     * The start time for the metric (ISO-8601 format).
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private String startTime;

    /*
     * The end time for the metric (ISO-8601 format).
     */
    @JsonProperty(value = "endTime", access = JsonProperty.Access.WRITE_ONLY)
    private String endTime;

    /*
     * List of intervals with appropriate metric data
     */
    @JsonProperty(value = "intervals")
    private List<QueryMetricInterval> intervals;

    /** Creates an instance of QueryStatisticsProperties class. */
    public QueryStatisticsProperties() {
    }

    /**
     * Get the databaseName property: Database name of the database in which this query was executed.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Get the queryId property: Unique query id (unique within one database).
     *
     * @return the queryId value.
     */
    public String queryId() {
        return this.queryId;
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     *
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     *
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Get the intervals property: List of intervals with appropriate metric data.
     *
     * @return the intervals value.
     */
    public List<QueryMetricInterval> intervals() {
        return this.intervals;
    }

    /**
     * Set the intervals property: List of intervals with appropriate metric data.
     *
     * @param intervals the intervals value to set.
     * @return the QueryStatisticsProperties object itself.
     */
    public QueryStatisticsProperties withIntervals(List<QueryMetricInterval> intervals) {
        this.intervals = intervals;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (intervals() != null) {
            intervals().forEach(e -> e.validate());
        }
    }
}
