// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.SecurityEventSqlInjectionAdditionalProperties;
import com.azure.resourcemanager.sql.models.SecurityEventType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A security event. */
@Immutable
public final class SecurityEventInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private SecurityEventProperties innerProperties;

    /** Creates an instance of SecurityEventInner class. */
    public SecurityEventInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private SecurityEventProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the eventTime property: The time when the security event occurred.
     *
     * @return the eventTime value.
     */
    public OffsetDateTime eventTime() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTime();
    }

    /**
     * Get the securityEventType property: The type of the security event.
     *
     * @return the securityEventType value.
     */
    public SecurityEventType securityEventType() {
        return this.innerProperties() == null ? null : this.innerProperties().securityEventType();
    }

    /**
     * Get the subscription property: The subscription name.
     *
     * @return the subscription value.
     */
    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    /**
     * Get the server property: The server name.
     *
     * @return the server value.
     */
    public String server() {
        return this.innerProperties() == null ? null : this.innerProperties().server();
    }

    /**
     * Get the database property: The database name.
     *
     * @return the database value.
     */
    public String database() {
        return this.innerProperties() == null ? null : this.innerProperties().database();
    }

    /**
     * Get the clientIp property: The IP address of the client who executed the statement.
     *
     * @return the clientIp value.
     */
    public String clientIp() {
        return this.innerProperties() == null ? null : this.innerProperties().clientIp();
    }

    /**
     * Get the applicationName property: The application used to execute the statement.
     *
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationName();
    }

    /**
     * Get the principalName property: The principal user who executed the statement.
     *
     * @return the principalName value.
     */
    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    /**
     * Get the securityEventSqlInjectionAdditionalProperties property: The sql injection additional properties,
     * populated only if the type of the security event is sql injection.
     *
     * @return the securityEventSqlInjectionAdditionalProperties value.
     */
    public SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties() {
        return this.innerProperties() == null
            ? null
            : this.innerProperties().securityEventSqlInjectionAdditionalProperties();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
