// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
 */
public enum BlobAuditingPolicyState {
    /** Enum value Enabled. */
    ENABLED("Enabled"),

    /** Enum value Disabled. */
    DISABLED("Disabled");

    /** The actual serialized value for a BlobAuditingPolicyState instance. */
    private final String value;

    BlobAuditingPolicyState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a BlobAuditingPolicyState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed BlobAuditingPolicyState object, or null if unable to parse.
     */
    @JsonCreator
    public static BlobAuditingPolicyState fromString(String value) {
        if (value == null) {
            return null;
        }
        BlobAuditingPolicyState[] items = BlobAuditingPolicyState.values();
        for (BlobAuditingPolicyState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
