// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Server info for the server trust group. */
@Fluent
public final class ServerInfo {
    /*
     * Server Id.
     */
    @JsonProperty(value = "serverId", required = true)
    private String serverId;

    /** Creates an instance of ServerInfo class. */
    public ServerInfo() {
    }

    /**
     * Get the serverId property: Server Id.
     *
     * @return the serverId value.
     */
    public String serverId() {
        return this.serverId;
    }

    /**
     * Set the serverId property: Server Id.
     *
     * @param serverId the serverId value to set.
     * @return the ServerInfo object itself.
     */
    public ServerInfo withServerId(String serverId) {
        this.serverId = serverId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serverId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property serverId in model ServerInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServerInfo.class);
}
