/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ImportExportOperationResultInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImportExportResponseImpl;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.ImportExistingDatabaseDefinition;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseImportExportResponse;
import com.azure.resourcemanager.sql.models.SqlDatabaseImportRequest;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlDatabaseImportRequestImpl
extends ExecutableImpl<SqlDatabaseImportExportResponse>
implements SqlDatabaseImportRequest,
SqlDatabaseImportRequest.SqlDatabaseImportRequestDefinition {
    private final SqlDatabaseImpl sqlDatabase;
    private final SqlServerManager sqlServerManager;
    private ImportExistingDatabaseDefinition inner;

    SqlDatabaseImportRequestImpl(SqlDatabaseImpl sqlDatabase, SqlServerManager sqlServerManager) {
        this.sqlDatabase = sqlDatabase;
        this.sqlServerManager = sqlServerManager;
        this.inner = new ImportExistingDatabaseDefinition();
    }

    public SqlDatabase parent() {
        return null;
    }

    public ImportExistingDatabaseDefinition innerModel() {
        return this.inner;
    }

    public Mono<SqlDatabaseImportExportResponse> executeWorkAsync() {
        SqlDatabaseImportRequestImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().importMethodAsync(this.sqlDatabase.resourceGroupName, this.sqlDatabase.sqlServerName, this.sqlDatabase.name(), this.innerModel()).flatMap(importExportResponseInner -> self.sqlDatabase.refreshAsync().map(sqlDatabase -> new SqlDatabaseImportExportResponseImpl((ImportExportOperationResultInner)((Object)importExportResponseInner))));
    }

    private Mono<Indexable> getOrCreateStorageAccountContainer(StorageAccount storageAccount, String containerName, String fileName, FunctionalTaskItem.Context context) {
        SqlDatabaseImportRequestImpl self = this;
        return storageAccount.getKeysAsync().flatMap(storageAccountKeys -> Mono.justOrEmpty(storageAccountKeys.stream().findFirst())).flatMap(storageAccountKey -> {
            self.inner.withStorageUri(String.format("%s%s/%s", storageAccount.endPoints().primary().blob(), containerName, fileName));
            self.inner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
            self.inner.withStorageKey(storageAccountKey.value());
            return context.voidMono();
        });
    }

    @Override
    public SqlDatabaseImportRequestImpl importFrom(String storageUri) {
        if (this.inner == null) {
            this.inner = new ImportExistingDatabaseDefinition();
        }
        this.inner.withStorageUri(storageUri);
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl importFrom(StorageAccount storageAccount, String containerName, String fileName) {
        Objects.requireNonNull(storageAccount);
        Objects.requireNonNull(containerName);
        Objects.requireNonNull(fileName);
        if (this.inner == null) {
            this.inner = new ImportExistingDatabaseDefinition();
        }
        this.addDependency(context -> this.getOrCreateStorageAccountContainer(storageAccount, containerName, fileName, (FunctionalTaskItem.Context)context));
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl withStorageAccessKey(String storageAccessKey) {
        this.inner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
        this.inner.withStorageKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl withSharedAccessKey(String sharedAccessKey) {
        this.inner.withStorageKeyType(StorageKeyType.SHARED_ACCESS_KEY);
        this.inner.withStorageKey(sharedAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImportRequestImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAuthenticationType(AuthenticationType.SQL.toString());
        return this.withLoginAndPassword(administratorLogin, administratorPassword);
    }

    @Override
    public SqlDatabaseImportRequestImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAuthenticationType(AuthenticationType.ADPASSWORD.toString());
        return this.withLoginAndPassword(administratorLogin, administratorPassword);
    }

    SqlDatabaseImportRequestImpl withLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.inner.withAdministratorLogin(administratorLogin);
        this.inner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }
}

