/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.JobAgentProperties;
import com.azure.resourcemanager.sql.models.JobAgentState;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class JobAgentInner
extends Resource {
    private Sku sku;
    private JobAgentProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public JobAgentInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private JobAgentProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public JobAgentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public JobAgentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String databaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseId();
    }

    public JobAgentInner withDatabaseId(String databaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobAgentProperties();
        }
        this.innerProperties().withDatabaseId(databaseId);
        return this;
    }

    public JobAgentState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobAgentInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobAgentInner)((Object)jsonReader.readObject(reader -> {
            JobAgentInner deserializedJobAgentInner = new JobAgentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobAgentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobAgentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobAgentInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedJobAgentInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedJobAgentInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedJobAgentInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobAgentInner.innerProperties = JobAgentProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobAgentInner;
        }));
    }
}

