/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ReplicationLinkProperties;
import com.azure.resourcemanager.sql.models.ReplicationLinkType;
import com.azure.resourcemanager.sql.models.ReplicationRole;
import com.azure.resourcemanager.sql.models.ReplicationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ReplicationLinkInner
extends ProxyResource {
    private ReplicationLinkProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ReplicationLinkProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String partnerServer() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerServer();
    }

    public String partnerDatabase() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerDatabase();
    }

    public String partnerLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerLocation();
    }

    public ReplicationRole role() {
        return this.innerProperties() == null ? null : this.innerProperties().role();
    }

    public ReplicationRole partnerRole() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRole();
    }

    public String replicationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationMode();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public Integer percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    public ReplicationState replicationState() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationState();
    }

    public Boolean isTerminationAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isTerminationAllowed();
    }

    public ReplicationLinkType linkType() {
        return this.innerProperties() == null ? null : this.innerProperties().linkType();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationLinkInner)((Object)jsonReader.readObject(reader -> {
            ReplicationLinkInner deserializedReplicationLinkInner = new ReplicationLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReplicationLinkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReplicationLinkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReplicationLinkInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReplicationLinkInner.innerProperties = ReplicationLinkProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationLinkInner;
        }));
    }
}

