/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SecurityEventSqlInjectionAdditionalProperties;
import com.azure.resourcemanager.sql.models.SecurityEventType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SecurityEventProperties
implements JsonSerializable<SecurityEventProperties> {
    private OffsetDateTime eventTime;
    private SecurityEventType securityEventType;
    private String subscription;
    private String server;
    private String database;
    private String clientIp;
    private String applicationName;
    private String principalName;
    private SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties;

    public OffsetDateTime eventTime() {
        return this.eventTime;
    }

    public SecurityEventType securityEventType() {
        return this.securityEventType;
    }

    public String subscription() {
        return this.subscription;
    }

    public String server() {
        return this.server;
    }

    public String database() {
        return this.database;
    }

    public String clientIp() {
        return this.clientIp;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String principalName() {
        return this.principalName;
    }

    public SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties() {
        return this.securityEventSqlInjectionAdditionalProperties;
    }

    public void validate() {
        if (this.securityEventSqlInjectionAdditionalProperties() != null) {
            this.securityEventSqlInjectionAdditionalProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SecurityEventProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityEventProperties)jsonReader.readObject(reader -> {
            SecurityEventProperties deserializedSecurityEventProperties = new SecurityEventProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eventTime".equals(fieldName)) {
                    deserializedSecurityEventProperties.eventTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("securityEventType".equals(fieldName)) {
                    deserializedSecurityEventProperties.securityEventType = SecurityEventType.fromString(reader.getString());
                    continue;
                }
                if ("subscription".equals(fieldName)) {
                    deserializedSecurityEventProperties.subscription = reader.getString();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedSecurityEventProperties.server = reader.getString();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedSecurityEventProperties.database = reader.getString();
                    continue;
                }
                if ("clientIp".equals(fieldName)) {
                    deserializedSecurityEventProperties.clientIp = reader.getString();
                    continue;
                }
                if ("applicationName".equals(fieldName)) {
                    deserializedSecurityEventProperties.applicationName = reader.getString();
                    continue;
                }
                if ("principalName".equals(fieldName)) {
                    deserializedSecurityEventProperties.principalName = reader.getString();
                    continue;
                }
                if ("securityEventSqlInjectionAdditionalProperties".equals(fieldName)) {
                    deserializedSecurityEventProperties.securityEventSqlInjectionAdditionalProperties = SecurityEventSqlInjectionAdditionalProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityEventProperties;
        });
    }
}

