/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ManagedInstanceFamilyCapability;
import com.azure.resourcemanager.sql.models.StorageCapability;
import java.io.IOException;
import java.util.List;

public final class ManagedInstanceEditionCapability
implements JsonSerializable<ManagedInstanceEditionCapability> {
    private String name;
    private List<ManagedInstanceFamilyCapability> supportedFamilies;
    private List<StorageCapability> supportedStorageCapabilities;
    private Boolean zoneRedundant;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<ManagedInstanceFamilyCapability> supportedFamilies() {
        return this.supportedFamilies;
    }

    public List<StorageCapability> supportedStorageCapabilities() {
        return this.supportedStorageCapabilities;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ManagedInstanceEditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedFamilies() != null) {
            this.supportedFamilies().forEach(e -> e.validate());
        }
        if (this.supportedStorageCapabilities() != null) {
            this.supportedStorageCapabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceEditionCapability)jsonReader.readObject(reader -> {
            ManagedInstanceEditionCapability deserializedManagedInstanceEditionCapability = new ManagedInstanceEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedFamilies".equals(fieldName)) {
                    List supportedFamilies;
                    deserializedManagedInstanceEditionCapability.supportedFamilies = supportedFamilies = reader.readArray(reader1 -> ManagedInstanceFamilyCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedStorageCapabilities".equals(fieldName)) {
                    List supportedStorageCapabilities;
                    deserializedManagedInstanceEditionCapability.supportedStorageCapabilities = supportedStorageCapabilities = reader.readArray(reader1 -> StorageCapability.fromJson(reader1));
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedManagedInstanceEditionCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceEditionCapability;
        });
    }
}

